/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.processors.imageprocessing.jvm.processor.genericclassification;

import boofcv.abst.scene.ImageClassifier;
import boofcv.factory.scene.ClassifierAndSource;
import boofcv.factory.scene.FactoryImageClassifier;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.Planar;
import deepboof.io.DeepBoofDataBaseOps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.streampipes.commons.exceptions.SpRuntimeException;
import org.apache.streampipes.extensions.api.pe.context.EventProcessorRuntimeContext;
import org.apache.streampipes.extensions.api.pe.routing.SpOutputCollector;
import org.apache.streampipes.model.DataProcessorType;
import org.apache.streampipes.model.graph.DataProcessorDescription;
import org.apache.streampipes.model.output.OutputStrategy;
import org.apache.streampipes.model.runtime.Event;
import org.apache.streampipes.model.schema.EventProperty;
import org.apache.streampipes.model.schema.PropertyScope;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImagePropertyConstants;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.PlainImageTransformer;
import org.apache.streampipes.sdk.builder.ProcessingElementBuilder;
import org.apache.streampipes.sdk.builder.StreamRequirementsBuilder;
import org.apache.streampipes.sdk.extractor.ProcessingElementParameterExtractor;
import org.apache.streampipes.sdk.helpers.EpProperties;
import org.apache.streampipes.sdk.helpers.EpRequirements;
import org.apache.streampipes.sdk.helpers.Label;
import org.apache.streampipes.sdk.helpers.Labels;
import org.apache.streampipes.sdk.helpers.Locales;
import org.apache.streampipes.sdk.helpers.OutputStrategies;
import org.apache.streampipes.wrapper.params.compat.ProcessorParams;
import org.apache.streampipes.wrapper.standalone.StreamPipesDataProcessor;

public class GenericImageClassificationProcessor
extends StreamPipesDataProcessor {
    private String imagePropertyName;
    private ClassifierAndSource cs;
    private ImageClassifier<Planar<GrayF32>> classifier;
    private List<String> categories;

    public DataProcessorDescription declareModel() {
        return (DataProcessorDescription)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)ProcessingElementBuilder.create((String)"org.apache.streampipes.processor.imageclassification.jvm.generic-image-classification").category(new DataProcessorType[]{DataProcessorType.IMAGE_PROCESSING}).withAssets(new String[]{"documentation.md"})).withLocales(new Locales[]{Locales.EN})).requiredStream(StreamRequirementsBuilder.create().requiredPropertyWithUnaryMapping((EventProperty)EpRequirements.domainPropertyReq((String)"https://image.com"), Labels.withId((String)ImagePropertyConstants.IMAGE_MAPPING.getProperty()), PropertyScope.NONE).build())).outputStrategy((OutputStrategy)OutputStrategies.append((EventProperty[])new EventProperty[]{EpProperties.doubleEp((Label)Labels.empty(), (String)"score", (String)"https://schema.org/score"), EpProperties.stringEp((Label)Labels.empty(), (String)"category", (String)"https://schema.org/category")})).build();
    }

    public void onInvocation(ProcessorParams parameters, SpOutputCollector spOutputCollector, EventProcessorRuntimeContext runtimeContext) throws SpRuntimeException {
        ProcessingElementParameterExtractor extractor = parameters.extractor();
        this.imagePropertyName = extractor.mappingPropertyValue(ImagePropertyConstants.IMAGE_MAPPING.getProperty());
        ClassifierAndSource cs = FactoryImageClassifier.nin_imagenet();
        File path = DeepBoofDataBaseOps.downloadModel((List)cs.getSource(), (File)new File("download_data"));
        this.classifier = cs.getClassifier();
        try {
            this.classifier.loadModel(path);
        }
        catch (IOException e) {
            throw new SpRuntimeException(e.getMessage());
        }
        this.categories = this.classifier.getCategories();
    }

    public void onEvent(Event in, SpOutputCollector out) throws SpRuntimeException {
        PlainImageTransformer imageTransformer = new PlainImageTransformer(in);
        Optional<BufferedImage> imageOpt = imageTransformer.getImage(this.imagePropertyName);
        if (imageOpt.isPresent()) {
            BufferedImage buffered = imageOpt.get();
            Planar image = new Planar(GrayF32.class, buffered.getWidth(), buffered.getHeight(), 3);
            ConvertBufferedImage.convertFromPlanar((BufferedImage)buffered, (Planar)image, (boolean)true, GrayF32.class);
            this.classifier.classify((ImageBase)image);
            List scores = this.classifier.getAllResults();
            scores.sort((o1, o2) -> Double.compare(o2.score, o1.score));
            if (!scores.isEmpty()) {
                System.out.println(((ImageClassifier.Score)scores.get((int)0)).score + ":" + this.categories.get(((ImageClassifier.Score)scores.get((int)0)).category));
                in.addField("score", Double.valueOf(((ImageClassifier.Score)scores.get((int)0)).score));
                in.addField("category", this.categories.get(((ImageClassifier.Score)scores.get((int)0)).category));
                out.collect(in);
            }
        }
    }

    public void onDetach() throws SpRuntimeException {
    }
}

