/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.processors.imageprocessing.jvm.processor.commons;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.streampipes.model.runtime.Event;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImagePropertyConstants;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.PlainImageTransformer;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.imageenrichment.BoxCoordinates;

public class ImageTransformer
extends PlainImageTransformer {
    public ImageTransformer(Event in) {
        super(in);
    }

    @Override
    public Optional<BufferedImage> getImage(String imageProperty) {
        return this.getImage(imageProperty);
    }

    public List<Map<String, Object>> getAllBoxCoordinates(String boxArrayProperty) {
        List allBoxes = this.in.getFieldBySelector(boxArrayProperty).getAsList().parseAsCustomType(value -> (Map)value.getAsComposite().getRawValue());
        ArrayList<Map<String, Object>> allBoxesMap = new ArrayList<Map<String, Object>>();
        allBoxes.forEach(box -> {
            HashMap boxMap = new HashMap();
            box.forEach((key, value) -> boxMap.put(value.getFieldNameIn(), value.getRawValue()));
            allBoxesMap.add(boxMap);
        });
        return allBoxesMap;
    }

    public BoxCoordinates getBoxCoordinates(BufferedImage image, Map<String, Object> box) {
        Float x = this.toFloat(box.get(ImagePropertyConstants.BOX_X.getProperty()));
        Float y = this.toFloat(box.get(ImagePropertyConstants.BOX_Y.getProperty()));
        Float width = this.toFloat(box.get(ImagePropertyConstants.BOX_WIDTH.getProperty()));
        Float height = this.toFloat(box.get(ImagePropertyConstants.BOX_HEIGHT.getProperty()));
        return BoxCoordinates.make(width, height, x, y);
    }

    public BoxCoordinates getBoxCoordinatesWithAnnotations(BufferedImage image, Map<String, Object> box) {
        Float x = this.toFloat(box.get(ImagePropertyConstants.BOX_X.getProperty()));
        Float y = this.toFloat(box.get(ImagePropertyConstants.BOX_Y.getProperty()));
        Float width = this.toFloat(box.get(ImagePropertyConstants.BOX_WIDTH.getProperty()));
        Float height = this.toFloat(box.get(ImagePropertyConstants.BOX_WIDTH.getProperty()));
        Float score = this.toFloat(box.get(ImagePropertyConstants.SCORE.getProperty()));
        String classesindex = this.toString(box.get(ImagePropertyConstants.CLASS_INDEX.getProperty()));
        return BoxCoordinates.make(width, height, x, y, score.floatValue(), classesindex);
    }

    private Float toFloat(Object obj) {
        return Float.valueOf(Float.parseFloat(this.toString(obj)));
    }

    private String toString(Object obj) {
        return String.valueOf(obj);
    }

    public Optional<byte[]> makeImage(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", baos);
            baos.flush();
            byte[] finalImage = baos.toByteArray();
            baos.close();
            return Optional.of(finalImage);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

