/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.container.extensions;

import java.util.List;
import javax.annotation.PreDestroy;
import org.apache.streampipes.connect.container.worker.init.ConnectWorkerRegistrationService;
import org.apache.streampipes.connect.container.worker.init.ConnectWorkerTagProvider;
import org.apache.streampipes.container.extensions.ExtensionsResourceConfig;
import org.apache.streampipes.container.init.DeclarersSingleton;
import org.apache.streampipes.container.model.SpServiceDefinition;
import org.apache.streampipes.container.standalone.init.PipelineElementServiceShutdownHandler;
import org.apache.streampipes.container.standalone.init.PipelineElementServiceTagProvider;
import org.apache.streampipes.service.extensions.base.StreamPipesExtensionsServiceBase;
import org.apache.streampipes.svcdiscovery.api.model.SpServiceTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableAutoConfiguration
@Import(value={ExtensionsResourceConfig.class})
public abstract class ExtensionsModelSubmitter
extends StreamPipesExtensionsServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExtensionsModelSubmitter.class.getCanonicalName());

    @PreDestroy
    public void onExit() {
        new PipelineElementServiceShutdownHandler().onShutdown();
        this.deregisterService(DeclarersSingleton.getInstance().getServiceId());
    }

    public void afterServiceRegistered(SpServiceDefinition serviceDef) {
        new ConnectWorkerRegistrationService().registerWorker(serviceDef);
    }

    protected List<SpServiceTag> getExtensionsServiceTags() {
        List serviceTags = new PipelineElementServiceTagProvider().extractServiceTags();
        serviceTags.addAll(new ConnectWorkerTagProvider().extractServiceTags());
        return serviceTags;
    }
}

