/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.extensions.connectors.pulsar.adapter;

import org.apache.streampipes.extensions.api.extractor.IStaticPropertyExtractor;

public class PulsarConfig {
    private final String brokerUrl;
    private final String topic;
    private final String subscriptionName;

    public PulsarConfig(String brokerUrl, String topic, String subscriptionName) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.subscriptionName = subscriptionName;
    }

    public static PulsarConfig from(IStaticPropertyExtractor extractor) {
        String brokerHost = (String)extractor.singleValueParameter("pulsar-broker-host", String.class);
        Integer brokerPort = (Integer)extractor.singleValueParameter("pulsar-broker-port", Integer.class);
        String brokerUrl = brokerHost + ":" + brokerPort;
        String topic = (String)extractor.singleValueParameter("pulsar-topic", String.class);
        String subscriptionName = (String)extractor.singleValueParameter("pulsar-subscription-name", String.class);
        return new PulsarConfig(brokerUrl, topic, subscriptionName);
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }
}

