/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TenantUMDataDeletionUtil {
    public static final Log log = LogFactory.getLog(TenantUMDataDeletionUtil.class);

    public static void deleteTenantUMData(int tenantId, Connection conn) throws Exception {
        try {
            conn.setAutoCommit(false);
            String deleteUserPermissionSql = "DELETE FROM UM_USER_PERMISSION WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteUserPermissionSql, tenantId);
            String deleteRolePermissionSql = "DELETE FROM UM_ROLE_PERMISSION WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteRolePermissionSql, tenantId);
            String deletePermissionSql = "DELETE FROM UM_PERMISSION WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deletePermissionSql, tenantId);
            String deleteClaimBehaviourSql = "DELETE FROM UM_CLAIM_BEHAVIOR WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteClaimBehaviourSql, tenantId);
            String deleteProfileConfigSql = "DELETE FROM UM_PROFILE_CONFIG WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteProfileConfigSql, tenantId);
            String deleteClaimSql = "DELETE FROM UM_CLAIM WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteClaimSql, tenantId);
            String deleteDialectSql = "DELETE FROM UM_DIALECT WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteDialectSql, tenantId);
            String deleteUserAttributeSql = "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteUserAttributeSql, tenantId);
            String deleteHybridUserRoleSql = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteHybridUserRoleSql, tenantId);
            String deleteHybridRoleSql = "DELETE FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteHybridRoleSql, tenantId);
            String deleteHybridRememberMeSql = "DELETE FROM UM_HYBRID_REMEMBER_ME WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteHybridRememberMeSql, tenantId);
            String deleteUserRoleSql = "DELETE FROM UM_USER_ROLE WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteUserRoleSql, tenantId);
            String deleteRoleSql = "DELETE FROM UM_ROLE WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteRoleSql, tenantId);
            String deleteUserSql = "DELETE FROM UM_USER WHERE UM_TENANT_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteUserSql, tenantId);
            String deleteTenantSql = "DELETE FROM UM_TENANT WHERE UM_ID = ?";
            TenantUMDataDeletionUtil.executeDeleteQuery(conn, deleteTenantSql, tenantId);
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            String errorMsg = "An error occurred while deleting registry data for tenant: " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            conn.close();
        }
    }

    private static void executeDeleteQuery(Connection conn, String query, int tenantId) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(query);
            ps.setInt(1, tenantId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String errMsg = "Error executing query " + query + " for tenant: " + tenantId;
            log.error((Object)errMsg, (Throwable)e);
            throw new Exception(errMsg, e);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

