/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.internal.util;

import java.util.Properties;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.stratos.tenant.mgt.services.InMemoryPasswordcallbackHandler;
import org.wso2.carbon.base.ServerConfiguration;

public class TenantMgtRampartUtil {
    public static Policy getDefaultRampartConfig() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
        String keyStoreType = serverConfig.getFirstProperty("Security.KeyStore.Type");
        String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
        String privateKeyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        String privateKeyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
        RampartConfig rampartConfig = new RampartConfig();
        rampartConfig.setUser(privateKeyAlias);
        rampartConfig.setPwCbClass("org.apache.stratos.tenant.mgt.services.InMemoryPasswordcallbackHandler");
        InMemoryPasswordcallbackHandler.addUser(privateKeyAlias, privateKeyPassword);
        CryptoConfig sigCrypto = new CryptoConfig();
        Properties props = new Properties();
        sigCrypto.setProvider("org.apache.ws.security.components.crypto.Merlin");
        props.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", keyStoreType);
        props.setProperty("org.apache.ws.security.crypto.merlin.file", keyStore);
        props.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePassword);
        sigCrypto.setProp(props);
        rampartConfig.setSigCryptoConfig(sigCrypto);
        Policy policy = new Policy();
        policy.addAssertion((Assertion)rampartConfig);
        return policy;
    }
}

