/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.config.CloudServiceConfigParser;
import org.apache.stratos.common.config.CloudServicesDescConfig;
import org.apache.stratos.common.util.CloudServicesUtil;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.tenant.mgt.core.internal.TenantMgtCoreServiceComponent;
import org.apache.stratos.tenant.mgt.core.util.TenantCoreUtil;
import org.wso2.carbon.core.multitenancy.persistence.TenantPersistor;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class DefaultTenantPersistor
implements TenantPersistor {
    private static final Log log = LogFactory.getLog(DefaultTenantPersistor.class);
    private static final String ILLEGAL_CHARACTERS_FOR_PATH = ".*[~!#$;%^*()+={}\\[\\]\\|\\\\<>].*";
    private static CloudServicesDescConfig cloudServicesDesc = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int persistTenant(org.wso2.carbon.user.core.tenant.Tenant tenant, boolean checkDomainValidation, String successKey, String originatedService) throws Exception {
        this.validateAdminUserName(tenant);
        String tenantDomain = tenant.getDomain();
        boolean isDomainAvailable = CommonUtil.isDomainNameAvailable((String)tenantDomain);
        if (!isDomainAvailable) {
            throw new Exception("Domain is not available to register");
        }
        RealmService realmService = TenantMgtCoreServiceComponent.getRealmService();
        RealmConfiguration realmConfig = realmService.getBootstrapRealmConfiguration();
        TenantMgtConfiguration tenantMgtConfiguration = realmService.getTenantMgtConfiguration();
        MultiTenantRealmConfigBuilder builder = TenantMgtCoreServiceComponent.getRealmService().getMultiTenantRealmConfigBuilder();
        RealmConfiguration realmConfigToPersist = builder.getRealmConfigForTenantToPersist(realmConfig, tenantMgtConfiguration, tenant, -1);
        tenant.setRealmConfig(realmConfigToPersist);
        int tenantId = this.addTenant(tenant);
        tenant.setId(tenantId);
        if (checkDomainValidation) {
            if (successKey != null) {
                if (!CommonUtil.validateDomainFromSuccessKey((UserRegistry)TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234), (String)tenant.getDomain(), (String)successKey)) {
                    String msg = "Failed to validate domain";
                    throw new Exception(msg);
                }
                this.storeDomainValidationFlagToRegistry(tenant);
            }
        } else {
            this.storeDomainValidationFlagToRegistry(tenant);
        }
        try {
            this.doPostTenantCreationActions(tenant, originatedService);
            return tenantId;
        }
        catch (Exception e) {
            String msg = "Error performing post tenant creation actions";
            throw new Exception(msg, e);
        }
    }

    private void doPostTenantCreationActions(org.wso2.carbon.user.core.tenant.Tenant tenant, String originatedService) throws Exception {
        UserRealm userRealm;
        RealmService realmService = TenantMgtCoreServiceComponent.getRealmService();
        try {
            userRealm = (UserRealm)realmService.getTenantUserRealm(tenant.getId());
        }
        catch (UserStoreException e) {
            String msg = "Error in creating Realm for tenant: " + tenant.getDomain();
            throw new Exception(msg, e);
        }
        this.updateTenantAdminPassword(userRealm, tenant);
        TenantMgtCoreServiceComponent.getRegistryLoader().loadTenantRegistry(tenant.getId());
        this.copyUIPermissions(tenant.getId());
        TenantCoreUtil.setOriginatedService(tenant.getId(), originatedService);
        this.setActivationFlags(tenant.getId(), originatedService);
        TenantCoreUtil.initializeRegistry(tenant.getId());
    }

    private void storeDomainValidationFlagToRegistry(org.wso2.carbon.user.core.tenant.Tenant tenant) throws RegistryException {
        try {
            String domainValidationPath = "/repository/components/org.wso2.carbon.domain-confirmation-flag/" + tenant.getId();
            UserRegistry superTenantRegistry = TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234);
            Resource validationFlagR = superTenantRegistry.newResource();
            validationFlagR.setProperty(tenant.getDomain(), "true");
            superTenantRegistry.put(domainValidationPath, validationFlagR);
        }
        catch (RegistryException e) {
            String msg = "Error in storing the domain validation flag to the registry";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Domain Validation Flag is stored to the registry.");
        }
    }

    private int addTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        int tenantId;
        TenantManager tenantManager = TenantMgtCoreServiceComponent.getTenantManager();
        try {
            tenantId = tenantManager.addTenant((Tenant)tenant);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant is successfully added: " + tenant.getDomain()));
            }
        }
        catch (UserStoreException e) {
            String msg = "Error in adding tenant with domain: " + tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return tenantId;
    }

    private void updateTenantAdminPassword(UserRealm userRealm, org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        try {
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            if (!userStoreManager.isReadOnly()) {
                userStoreManager.updateCredentialByAdmin(tenant.getAdminName(), (Object)tenant.getAdminPassword());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully set the password for the tenant.");
                }
            }
        }
        catch (UserStoreException e) {
            String msg = "Error in changing the tenant admin password for tenant domain: " + tenant.getDomain() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private void copyUIPermissions(int tenantId) throws Exception {
        try {
            UserRealm realm = (UserRealm)TenantMgtCoreServiceComponent.getRealmService().getTenantUserRealm(tenantId);
            String adminRole = realm.getRealmConfiguration().getAdminRoleName();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            if (!authMan.isRoleAuthorized(adminRole, "/permission/admin", "ui.execute")) {
                authMan.authorizeRole(adminRole, "/permission/admin", "ui.execute");
            }
        }
        catch (UserStoreException e) {
            String msg = "Error in authorizing the admin role.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Role has successfully been authorized.");
        }
    }

    private void setActivationFlags(int tenantId, String originalService) throws Exception {
        boolean useDefaultConfig = true;
        try {
            if (cloudServicesDesc == null) {
                cloudServicesDesc = CloudServiceConfigParser.loadCloudServicesConfiguration();
            }
            if (originalService != null && !originalService.equals("Apache Stratos Controller")) {
                CloudServicesUtil.activateOriginalAndCompulsoryServices((CloudServicesDescConfig)cloudServicesDesc, (String)originalService, (int)tenantId);
                useDefaultConfig = false;
            }
            if (useDefaultConfig) {
                CloudServicesUtil.activateAllServices((CloudServicesDescConfig)cloudServicesDesc, (int)tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error registering the originated service", (Throwable)e);
            throw e;
        }
    }

    private void validateAdminUserName(org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        UserRealm superTenantUserRealm = TenantMgtCoreServiceComponent.getRealmService().getBootstrapRealm();
        RealmConfiguration realmConfig = TenantMgtCoreServiceComponent.getBootstrapRealmConfiguration();
        String uniqueAcrossTenants = realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if ("true".equals(uniqueAcrossTenants)) {
            try {
                if (superTenantUserRealm.getUserStoreManager().isExistingUser(tenant.getAdminName())) {
                    throw new Exception("User name : " + tenant.getAdminName() + " exists in the system. " + "Please pick another user name for tenant Administrator.");
                }
            }
            catch (UserStoreException e) {
                String msg = "Error in checking whether the user already exists in the system";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        if (tenant.getAdminName().matches(ILLEGAL_CHARACTERS_FOR_PATH)) {
            String msg = "The tenant admin ' " + tenant.getAdminName() + " ' contains one or more illegal characters" + " (~!@#$;%^*()+={}[]|\\<>)";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Admin User Name has been validated.");
        }
    }

    public int persistTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        String tenantDomain = tenant.getDomain();
        this.validateAdminUserName(tenant);
        boolean isDomainAvailable = CommonUtil.isDomainNameAvailable((String)tenantDomain);
        if (!isDomainAvailable) {
            throw new Exception("Domain is not available to register");
        }
        int tenantId = this.addTenant(tenant);
        tenant.setId(tenantId);
        try {
            this.doPostTenantCreationActions(tenant, null);
        }
        catch (Exception e) {
            String msg = "Error performing post tenant creation actions";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new Exception(msg);
        }
        return tenantId;
    }
}

