/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.stratos.tenant.activity.beans.PaginatedTenantDataBean;
import org.apache.stratos.tenant.activity.beans.TenantDataBean;
import org.apache.stratos.tenant.activity.util.TenantActivityUtil;
import org.apache.stratos.tenant.activity.util.Util;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

public class TenantActivityService
extends AbstractAdmin {
    List<String> list = new ArrayList<String>();

    public int getActiveTenantCount() throws Exception {
        return this.getAllActiveTenantList().size();
    }

    private List<TenantDataBean> getAllActiveTenantList() throws Exception {
        ArrayList<TenantDataBean> list = new ArrayList<TenantDataBean>();
        for (Tenant tenant : TenantAxisUtils.getActiveTenants((ConfigurationContext)Util.getConfigurationContextService().getServerConfigContext())) {
            TenantDataBean tb = new TenantDataBean();
            tb.setDomain(tenant.getDomain());
            list.add(tb);
        }
        for (TenantDataBean tenantDataBean : TenantActivityUtil.getActiveTenantsInCluster()) {
            if (TenantActivityUtil.indexOfTenantInList(list, tenantDataBean) >= 0) continue;
            list.add(tenantDataBean);
        }
        return list;
    }

    public PaginatedTenantDataBean retrievePaginatedActiveTenants(int pageNumber) throws Exception {
        List<TenantDataBean> tenantList = this.getAllActiveTenantList();
        PaginatedTenantDataBean paginatedTenantInfoBean = new PaginatedTenantDataBean();
        DataPaginator.doPaging((int)pageNumber, tenantList, (Pageable)paginatedTenantInfoBean);
        return paginatedTenantInfoBean;
    }

    public boolean isActiveTenantOnService(String domainName) throws Exception {
        boolean state = false;
        for (TenantDataBean tenant : this.getAllActiveTenantList()) {
            if (!tenant.getDomain().equalsIgnoreCase(domainName)) continue;
            return true;
        }
        return state;
    }
}

