/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.tenant.activity.beans.TenantDataBean;
import org.apache.stratos.tenant.activity.commands.GetActiveTenantsInMemberResponse;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.user.api.Tenant;

public class GetActiveTenantsInMemberRequest
extends ClusteringMessage {
    private static final Log log = LogFactory.getLog(GetActiveTenantsInMemberRequest.class);
    private List<TenantDataBean> tenants = new ArrayList<TenantDataBean>();

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        try {
            for (Tenant tenant : TenantAxisUtils.getActiveTenants((ConfigurationContext)configurationContext)) {
                TenantDataBean tb = new TenantDataBean();
                tb.setDomain(tenant.getDomain());
                this.tenants.add(tb);
            }
        }
        catch (Exception e) {
            String msg = "Cannot get Active tenants";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, e);
        }
    }

    public ClusteringCommand getResponse() {
        return new GetActiveTenantsInMemberResponse(this.tenants);
    }
}

