/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.ClusterCreatedEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterRemovedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.InstanceSpawnedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberMaintenanceListener;
import org.apache.stratos.messaging.listener.topology.MemberReadyToShutdownEventListener;
import org.apache.stratos.messaging.listener.topology.MemberStartedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.listener.topology.ServiceCreatedEventListener;
import org.apache.stratos.messaging.listener.topology.ServiceRemovedEventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.topology.ClusterCreatedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.ClusterRemovedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.CompleteTopologyMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.InstanceSpawnedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberActivatedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberMaintenanceModeProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberReadyToShutdownMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberStartedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberSuspendedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.MemberTerminatedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.ServiceCreatedMessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.ServiceRemovedMessageProcessor;

public class TopologyMessageProcessorChain
extends MessageProcessorChain {
    private static final Log log = LogFactory.getLog(TopologyMessageProcessorChain.class);
    private CompleteTopologyMessageProcessor completeTopologyMessageProcessor;
    private ServiceCreatedMessageProcessor serviceCreatedMessageProcessor;
    private ServiceRemovedMessageProcessor serviceRemovedMessageProcessor;
    private ClusterCreatedMessageProcessor clusterCreatedMessageProcessor;
    private ClusterRemovedMessageProcessor clusterRemovedMessageProcessor;
    private InstanceSpawnedMessageProcessor instanceSpawnedMessageProcessor;
    private MemberStartedMessageProcessor memberStartedMessageProcessor;
    private MemberActivatedMessageProcessor memberActivatedMessageProcessor;
    private MemberReadyToShutdownMessageProcessor memberReadyToShutdownProcessor;
    private MemberMaintenanceModeProcessor memberMaintenanceModeProcessor;
    private MemberSuspendedMessageProcessor memberSuspendedMessageProcessor;
    private MemberTerminatedMessageProcessor memberTerminatedMessageProcessor;

    @Override
    public void initialize() {
        this.completeTopologyMessageProcessor = new CompleteTopologyMessageProcessor();
        this.add(this.completeTopologyMessageProcessor);
        this.serviceCreatedMessageProcessor = new ServiceCreatedMessageProcessor();
        this.add(this.serviceCreatedMessageProcessor);
        this.serviceRemovedMessageProcessor = new ServiceRemovedMessageProcessor();
        this.add(this.serviceRemovedMessageProcessor);
        this.clusterCreatedMessageProcessor = new ClusterCreatedMessageProcessor();
        this.add(this.clusterCreatedMessageProcessor);
        this.clusterRemovedMessageProcessor = new ClusterRemovedMessageProcessor();
        this.add(this.clusterRemovedMessageProcessor);
        this.instanceSpawnedMessageProcessor = new InstanceSpawnedMessageProcessor();
        this.add(this.instanceSpawnedMessageProcessor);
        this.memberStartedMessageProcessor = new MemberStartedMessageProcessor();
        this.add(this.memberStartedMessageProcessor);
        this.memberActivatedMessageProcessor = new MemberActivatedMessageProcessor();
        this.add(this.memberActivatedMessageProcessor);
        this.memberReadyToShutdownProcessor = new MemberReadyToShutdownMessageProcessor();
        this.add(this.memberReadyToShutdownProcessor);
        this.memberMaintenanceModeProcessor = new MemberMaintenanceModeProcessor();
        this.add(this.memberMaintenanceModeProcessor);
        this.memberSuspendedMessageProcessor = new MemberSuspendedMessageProcessor();
        this.add(this.memberSuspendedMessageProcessor);
        this.memberTerminatedMessageProcessor = new MemberTerminatedMessageProcessor();
        this.add(this.memberTerminatedMessageProcessor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Topology message processor chain initialized");
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof CompleteTopologyEventListener) {
            this.completeTopologyMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof ClusterCreatedEventListener) {
            this.clusterCreatedMessageProcessor.addEventListener(eventListener);
            log.info((Object)"Messaging: added ClusterCreatedEventListener");
        } else if (eventListener instanceof ClusterRemovedEventListener) {
            this.clusterRemovedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof InstanceSpawnedEventListener) {
            this.instanceSpawnedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberActivatedEventListener) {
            this.memberActivatedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberStartedEventListener) {
            this.memberStartedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberReadyToShutdownEventListener) {
            this.memberReadyToShutdownProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberSuspendedEventListener) {
            this.memberSuspendedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberTerminatedEventListener) {
            this.memberTerminatedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof ServiceCreatedEventListener) {
            this.serviceCreatedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof ServiceRemovedEventListener) {
            this.serviceRemovedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof MemberMaintenanceListener) {
            this.memberMaintenanceModeProcessor.addEventListener(eventListener);
        } else {
            throw new RuntimeException("Unknown event listener");
        }
    }
}

