/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.subscribe;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicConnector;
import org.apache.stratos.messaging.broker.heartbeat.TopicHealthChecker;

public class TopicSubscriber
implements Runnable {
    private static final Log log = LogFactory.getLog(TopicSubscriber.class);
    private boolean terminated = false;
    private MessageListener messageListener;
    private TopicSession topicSession;
    private String topicName;
    private TopicConnector connector;
    private TopicHealthChecker healthChecker;
    private javax.jms.TopicSubscriber topicSubscriber = null;
    private boolean subscribed;

    public TopicSubscriber(String aTopicName) {
        this.topicName = aTopicName;
        this.connector = new TopicConnector();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic subscriber connector created: [topic] %s", this.topicName));
        }
    }

    private void doSubscribe() throws Exception, JMSException {
        this.connector.init(this.topicName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic subscriber connector initialized: [topic] %s", this.topicName));
        }
        this.topicSession = this.createSession(this.connector);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic subscriber session created: [topic] %s", this.topicName));
        }
        this.createSubscriber(this.topicSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic subscriber created: [topic] %s", this.topicName));
        }
        this.subscribed = true;
    }

    private void createSubscriber(TopicSession topicSession) throws JMSException {
        Topic topic = this.connector.getTopic();
        if (topic == null) {
            topic = topicSession.createTopic(this.topicName);
        }
        this.topicSubscriber = topicSession.createSubscriber(topic);
        this.topicSubscriber.setMessageListener(this.messageListener);
    }

    private TopicSession createSession(TopicConnector topicConnector) throws Exception {
        return topicConnector.newSession();
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        while (!this.terminated) {
            Thread healthCheckerThread;
            block44: {
                block42: {
                    this.doSubscribe();
                    if (!this.subscribed) break block42;
                    this.healthChecker = new TopicHealthChecker(this.topicName);
                    healthCheckerThread = new Thread(this.healthChecker);
                    healthCheckerThread.start();
                    try {
                        healthCheckerThread.join();
                    }
                    catch (InterruptedException ignore) {}
                    break block44;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will try to subscribe again in 30 sec");
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            try {
                if (this.topicSubscriber != null) {
                    this.topicSubscriber.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic subscriber closed: [topic] %s", this.topicName));
                    }
                }
                if (this.topicSession != null) {
                    this.topicSession.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic subscriber session closed: [topic] %s", this.topicName));
                    }
                }
                if (this.connector == null) continue;
                this.connector.close();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Topic subscriber connector closed: [topic] %s", this.topicName));
            }
            catch (JMSException ignore) {}
            continue;
            catch (Exception e) {
                block45: {
                    block43: {
                        try {
                            this.subscribed = false;
                            log.error((Object)("Error while subscribing to the topic: " + this.topicName), (Throwable)e);
                            if (!this.subscribed) break block43;
                            this.healthChecker = new TopicHealthChecker(this.topicName);
                            healthCheckerThread = new Thread(this.healthChecker);
                            healthCheckerThread.start();
                        }
                        catch (Throwable throwable) {
                            if (this.subscribed) {
                                this.healthChecker = new TopicHealthChecker(this.topicName);
                                Thread healthCheckerThread2 = new Thread(this.healthChecker);
                                healthCheckerThread2.start();
                                try {
                                    healthCheckerThread2.join();
                                }
                                catch (InterruptedException ignore) {}
                            } else {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)"Will try to subscribe again in 30 sec");
                                }
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (this.topicSubscriber != null) {
                                    this.topicSubscriber.close();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("Topic subscriber closed: [topic] %s", this.topicName));
                                    }
                                }
                                if (this.topicSession != null) {
                                    this.topicSession.close();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("Topic subscriber session closed: [topic] %s", this.topicName));
                                    }
                                }
                                if (this.connector != null) {
                                    this.connector.close();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("Topic subscriber connector closed: [topic] %s", this.topicName));
                                    }
                                }
                            }
                            catch (JMSException ignore) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            healthCheckerThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                        break block45;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will try to subscribe again in 30 sec");
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                try {
                    if (this.topicSubscriber != null) {
                        this.topicSubscriber.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Topic subscriber closed: [topic] %s", this.topicName));
                        }
                    }
                    if (this.topicSession != null) {
                        this.topicSession.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Topic subscriber session closed: [topic] %s", this.topicName));
                        }
                    }
                    if (this.connector == null) continue;
                    this.connector.close();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Topic subscriber connector closed: [topic] %s", this.topicName));
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    public void terminate() {
        this.healthChecker.terminate();
        this.terminated = true;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }
}

