/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.conf.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Node
implements Serializable {
    private static final long serialVersionUID = 4071569903421115370L;
    private String name;
    private List<Node> childNodes = new ArrayList<Node>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public void setChildNodes(List<Node> childNodes) {
        this.childNodes = childNodes;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String childNodesToString(int indentation) {
        StringBuilder childNodesString = new StringBuilder();
        ++indentation;
        for (Node node : this.childNodes) {
            childNodesString.append(node.toString(indentation) + "\n");
        }
        return childNodesString.toString();
    }

    public Node findChildNodeByName(String name) {
        for (Node aNode : this.childNodes) {
            if (!aNode.getName().equals(name)) continue;
            return aNode;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        if (this.properties.get(key) == null) {
            return null;
        }
        return this.properties.get(key).trim();
    }

    public String propertiesToString(int indentation) {
        String indent = this.getIndentation(indentation);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if ("tenant_id".equals(entry.getKey()) || "alias".equals(entry.getKey())) continue;
            sb.append(indent + entry.getKey() + "\t" + entry.getValue() + ";\n");
        }
        return sb.toString();
    }

    public Node removeChildNode(String name) {
        Node aNode = this.findChildNodeByName(name);
        if (aNode != null && this.childNodes.remove(aNode)) {
            return aNode;
        }
        return null;
    }

    public boolean removeChildNode(Node node) {
        return this.childNodes.remove(node);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void appendChild(Node aNode) {
        if (aNode != null && !this.nodeAlreadyPresent(aNode)) {
            this.childNodes.add(aNode);
        }
    }

    public void addProperty(String key, String value) {
        if (key != null) {
            this.properties.put(key, value);
        }
    }

    public String toString() {
        String nodeString = this.getName() + " {\n" + this.propertiesToString(1) + this.childNodesToString(1) + "}";
        return nodeString;
    }

    public boolean equals(Object node) {
        if (node instanceof Node) {
            return this.getName().equals(((Node)node).getName()) && this.isIdenticalProperties(this.getProperties(), ((Node)node).getProperties()) && this.isIdenticalChildren(this.getChildNodes(), ((Node)node).getChildNodes());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).append(this.properties).append(this.childNodes).toHashCode();
    }

    private boolean isIdenticalChildren(List<Node> childNodes1, List<Node> childNodes2) {
        if (childNodes1.size() != childNodes2.size()) {
            return false;
        }
        block0: for (Node node1 : childNodes1) {
            int i = 0;
            for (Node node2 : childNodes2) {
                ++i;
                if (node1.equals(node2)) continue block0;
                if (i != childNodes1.size()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean nodeAlreadyPresent(Node aNode) {
        for (Node node : this.childNodes) {
            if (!node.equals(aNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isIdenticalProperties(Map<String, String> map1, Map<String, String> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        block0: for (Map.Entry<String, String> entry1 : map1.entrySet()) {
            int i = 0;
            for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                ++i;
                if (entry1.getKey().equals(entry2.getKey()) && entry1.getValue().equals(entry2.getValue())) continue block0;
                if (i != map1.size()) continue;
                return false;
            }
        }
        return true;
    }

    private String toString(int indentation) {
        String indent = this.getIndentation(indentation - 1);
        String nodeString = indent + this.getName() + " {\n" + this.propertiesToString(indentation) + this.childNodesToString(indentation) + indent + "}";
        return nodeString;
    }

    private String getIndentation(int tabs) {
        StringBuilder indent = new StringBuilder("");
        for (int i = 0; i < tabs; ++i) {
            indent.append("\t");
        }
        return indent.toString();
    }
}

