/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.lb.common.conf.structure.Node;
import org.apache.stratos.lb.common.conf.structure.NodeBuilder;
import org.apache.stratos.lb.common.conf.util.HostContext;
import org.apache.stratos.lb.common.conf.util.LoadBalancerConfigUtil;
import org.apache.synapse.commons.util.PropertyHelper;

public class LoadBalancerConfiguration
implements Serializable {
    protected static final long serialVersionUID = -5553545217542808233L;
    private static final Log log = LogFactory.getLog(LoadBalancerConfiguration.class);
    private Map<String, Map<String, ServiceConfiguration>> serviceConfigurations = new HashMap<String, Map<String, ServiceConfiguration>>();
    private transient Map<String, HostContext> hostCtxt = new HashMap<String, HostContext>();
    private Map<String, List<ServiceConfiguration>> serviceNameToServiceConfigurations = new HashMap<String, List<ServiceConfiguration>>();
    private Map<String, Set<String>> hostNamesTracker = new HashMap<String, Set<String>>();
    protected ServiceConfiguration defaultServiceConfig;
    protected LBConfiguration lbConfig;
    protected String lbConfigString;
    protected Node rootNode;
    private static LoadBalancerConfiguration instance;

    private LoadBalancerConfiguration() {
        this.init(System.getProperty("loadbalancer.conf"));
    }

    public static LoadBalancerConfiguration getInstance() {
        if (instance == null) {
            instance = new LoadBalancerConfiguration();
        }
        return instance;
    }

    public void init(String configURL) {
        Node servicesConfigNode;
        if (configURL == null) {
            String msg = "Cannot locate the location of the loadbalancer.conf file. You need to set the 'loadbalancer.conf' system property.";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (configURL.startsWith("$system:")) {
            configURL = System.getProperty(configURL.substring("$system:".length()));
        }
        try {
            this.lbConfigString = configURL.startsWith(File.separator) ? this.createLBConfigString(configURL) : this.createLBConfigString(new URL(configURL).openStream());
        }
        catch (Exception e) {
            String msg = "Cannot read configuration file from " + configURL;
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        this.rootNode = new Node();
        this.rootNode.setName("root");
        this.rootNode = NodeBuilder.buildNode(this.rootNode, this.lbConfigString);
        Node lbConfigNode = this.rootNode.findChildNodeByName("loadbalancer");
        if (lbConfigNode != null) {
            this.lbConfig = new LBConfiguration();
            this.createConfiguration(this.lbConfig, lbConfigNode);
        }
        if ((servicesConfigNode = this.rootNode.findChildNodeByName("services")) == null) {
            String msg = "Mandatory services element can not be found in the configuration file.";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.createServicesConfig(servicesConfigNode);
    }

    public List<ServiceConfiguration> createServicesConfig(Node servicesConfigNode) {
        ArrayList<ServiceConfiguration> currentServiceConfigs = new ArrayList<ServiceConfiguration>();
        Node defaultNode = servicesConfigNode.findChildNodeByName("defaults");
        if (defaultNode != null) {
            this.defaultServiceConfig = new ServiceConfiguration();
            this.createConfiguration(this.defaultServiceConfig, defaultNode);
        }
        for (Node serviceNode : servicesConfigNode.getChildNodes()) {
            String msg;
            Node domainsNode;
            if (serviceNode == defaultNode) continue;
            String serviceName = serviceNode.getName();
            if (serviceNode.getChildNodes().isEmpty() || !(domainsNode = serviceNode.getChildNodes().get(0)).getName().equals("domains")) {
                msg = "The mandatory domains element, child of the " + serviceName + " element is not specified in the configuration file. \n" + serviceNode.toString();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            if (domainsNode.getChildNodes().isEmpty()) {
                msg = "No domain is specified under domains of " + serviceName + " element.";
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            for (Node domain : domainsNode.getChildNodes()) {
                ServiceConfiguration serviceConfig = new ServiceConfiguration();
                serviceConfig.setServiceName(serviceName);
                serviceConfig.setDomain(domain.getName());
                this.createConfiguration(serviceConfig, serviceNode);
                this.createConfiguration(serviceConfig, domain);
                if (this.isDuplicatedHost(serviceNode.getName(), serviceConfig)) {
                    String msg2 = "Duplicated host names detected for different service domains.\nElement: \n" + serviceNode.toString();
                    log.error((Object)msg2);
                    throw new RuntimeException(msg2);
                }
                currentServiceConfigs.add(serviceConfig);
            }
        }
        for (ServiceConfiguration serviceConfiguration : currentServiceConfigs) {
            this.addServiceConfiguration(serviceConfiguration);
        }
        return currentServiceConfigs;
    }

    public boolean addServiceConfiguration(ServiceConfiguration serviceConfig) {
        String domain = serviceConfig.getDomain();
        if (domain == null) {
            String msg = "Domain of a Service Configuration cannot be null. Hence this Configuration will be neglected.";
            log.error((Object)msg);
            return false;
        }
        String subDomain = serviceConfig.getSubDomain();
        Map<String, ServiceConfiguration> map = this.serviceConfigurations.containsKey(domain) ? this.serviceConfigurations.get(domain) : new HashMap<String, ServiceConfiguration>();
        map.put(subDomain, serviceConfig);
        this.serviceConfigurations.put(domain, map);
        List<Object> configs = this.serviceNameToServiceConfigurations.get(serviceConfig.getServiceName()) == null ? new ArrayList() : this.serviceNameToServiceConfigurations.get(serviceConfig.getServiceName());
        if (!configs.contains(serviceConfig)) {
            configs.add(serviceConfig);
        }
        this.serviceNameToServiceConfigurations.put(serviceConfig.getServiceName(), configs);
        return true;
    }

    public ServiceConfiguration removeServiceConfiguration(String domain, String subDomain) {
        Map<String, ServiceConfiguration> map;
        ServiceConfiguration serviceConfig = null;
        if (domain == null) {
            String msg = "Domain of a Service Configuration cannot be null. Hence this Configuration will be neglected.";
            log.error((Object)msg);
            return null;
        }
        if (this.serviceConfigurations.containsKey(domain) && (map = this.serviceConfigurations.get(domain)) != null) {
            serviceConfig = map.remove(subDomain);
        }
        if (serviceConfig == null) {
            String msg = "No matching service configuration found for domain: " + domain + ", sub domain: " + subDomain;
            log.error((Object)msg);
            return null;
        }
        String serviceName = serviceConfig.getServiceName();
        if (serviceName != null && this.serviceNameToServiceConfigurations.containsKey(serviceName) && serviceConfig != null) {
            List<ServiceConfiguration> list = this.serviceNameToServiceConfigurations.get(serviceName);
            list.remove(serviceConfig);
            this.serviceNameToServiceConfigurations.put(serviceName, list);
        }
        if (this.hostNamesTracker.containsKey(serviceName)) {
            Set<String> allHosts = this.hostNamesTracker.get(serviceName);
            for (String hostName : serviceConfig.getHosts()) {
                if (hostName == null) continue;
                allHosts.remove(hostName);
                this.hostCtxt.remove(hostName);
            }
        }
        return serviceConfig;
    }

    public void resetData() {
        this.serviceConfigurations = new HashMap<String, Map<String, ServiceConfiguration>>();
        this.serviceNameToServiceConfigurations = new HashMap<String, List<ServiceConfiguration>>();
    }

    public boolean isDuplicatedHost(String name, ServiceConfiguration serviceConfig) {
        ArrayList hostsOtherThanMine = new ArrayList(this.hostNamesTracker.values().size());
        for (Map.Entry<String, Set<String>> entry : this.hostNamesTracker.entrySet()) {
            if (entry.getKey().equals(name)) continue;
            hostsOtherThanMine.addAll(entry.getValue());
        }
        for (String host : serviceConfig.getHosts()) {
            if (hostsOtherThanMine.isEmpty() || !hostsOtherThanMine.contains(host)) continue;
            return true;
        }
        this.addToHostNameTrackerMap(name, serviceConfig.getHosts());
        return false;
    }

    public void addToHostNameTrackerMap(String name, List<String> hosts) {
        Set<String> allHosts;
        if (this.hostNamesTracker.containsKey(name)) {
            allHosts = this.hostNamesTracker.get(name);
            allHosts.addAll(hosts);
        } else {
            allHosts = new HashSet<String>(hosts);
        }
        this.hostNamesTracker.put(name, allHosts);
    }

    public void addToHostContextMap(String hostName, HostContext ctxt) {
        if (hostName != null && ctxt != null) {
            this.hostCtxt.put(hostName, ctxt);
        }
    }

    public Map<String, HostContext> getHostContextMap() {
        Iterator<Set<String>> it = this.hostNamesTracker.values().iterator();
        while (it.hasNext()) {
            for (String hostName : it.next()) {
                HostContext ctxt = new HostContext(hostName);
                for (Map.Entry<String, Map<String, ServiceConfiguration>> parentMap : this.serviceConfigurations.entrySet()) {
                    block3: for (Map.Entry<String, ServiceConfiguration> childMap : parentMap.getValue().entrySet()) {
                        for (String string : childMap.getValue().getHosts()) {
                            if (!string.equals(hostName)) continue;
                            String tenantRange = childMap.getValue().getTenantRange();
                            String domain = parentMap.getKey();
                            String subDomain = childMap.getKey();
                            ctxt.addTenantDomainContexts(LoadBalancerConfigUtil.getTenantDomainContexts(tenantRange, domain, subDomain));
                            break;
                        }
                        for (Map.Entry entry : childMap.getValue().getUrl_suffix().entrySet()) {
                            if (!((String)entry.getKey()).equals(hostName)) continue;
                            ctxt.setUrlSuffix((String)entry.getValue());
                            continue block3;
                        }
                    }
                }
                this.hostCtxt.put(hostName, ctxt);
            }
        }
        return this.hostCtxt;
    }

    protected void createConfiguration(Configuration config, Node node) {
        if (node == null) {
            String msg = "The configuration element for " + config.getClass().getName() + " is null.";
            throw new RuntimeException(msg);
        }
        try {
            for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                PropertyHelper.setInstanceProperty((String)key, (Object)value, (Object)config);
            }
        }
        catch (Exception e) {
            String msg = "Error setting values to " + config.getClass().getName();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public LBConfiguration getLoadBalancerConfig() {
        return this.lbConfig;
    }

    public String[] getServiceDomains() {
        Object[] objs = this.serviceConfigurations.keySet().toArray();
        return (String[])Arrays.copyOf(objs, objs.length, String[].class);
    }

    public String[] getServiceSubDomains(String domain) {
        if (this.serviceConfigurations.get(domain) != null) {
            Object[] objs = this.serviceConfigurations.get(domain).keySet().toArray();
            return (String[])Arrays.copyOf(objs, objs.length, String[].class);
        }
        return new String[0];
    }

    public ServiceConfiguration getServiceConfig(String domain, String subDomain) {
        if (this.serviceConfigurations.get(domain) != null) {
            return this.serviceConfigurations.get(domain).get(subDomain);
        }
        return null;
    }

    public List<ServiceConfiguration> getServiceConfigs(String serviceName) {
        return this.serviceNameToServiceConfigurations.get(serviceName);
    }

    public String createLBConfigString(String configFileName) throws FileNotFoundException {
        StringBuilder lbConfigString = new StringBuilder("");
        File configFile = new File(configFileName);
        Scanner scanner = new Scanner(configFile);
        while (scanner.hasNextLine()) {
            lbConfigString.append(scanner.nextLine().trim() + "\n");
        }
        return lbConfigString.toString().trim();
    }

    public String createLBConfigString(InputStream configFileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(configFileName));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line.trim() + "\n");
        }
        return sb.toString().trim();
    }

    public Map<String, Set<String>> getHostNamesTracker() {
        return this.hostNamesTracker;
    }

    public Map<String, Map<String, ServiceConfiguration>> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public static void setInstance(LoadBalancerConfiguration instance) {
        LoadBalancerConfiguration.instance = instance;
    }

    public Map<String, List<ServiceConfiguration>> getServiceNameToServiceConfigurations() {
        return this.serviceNameToServiceConfigurations;
    }

    public class ServiceConfiguration
    extends Configuration
    implements Serializable {
        private String serviceName;
        private String publicIp;
        private static final long serialVersionUID = 8707314702788040116L;
        private int minAppInstances;
        private boolean minAppInstancesSet;
        private int maxAppInstances;
        private boolean maxAppInstancesSet;
        private int maxRequestsPerSecond;
        private boolean maxRequestsPerSecondSet;
        private double alarmingUpperRate;
        private boolean alarmingUpperRateSet;
        private double alarmingLowerRate;
        private boolean alarmingLowerRateSet;
        private double scaleDownFactor;
        private boolean scaleDownFactorSet;
        private int roundsToAverage;
        private boolean roundsToAverageSet;
        private int instancesPerScaleUp;
        private boolean instancesPerScaleUpSet;
        private int messageExpiryTime;
        private boolean messageExpiryTimeSet;
        private List<String> hosts;
        private Map<String, String> urlSuffixes;
        private boolean hostsSet;
        private String domain;
        private String tenantRange;
        private boolean tenantRangeSet;
        private String subDomain;
        private boolean subDomainSet;

        public ServiceConfiguration() {
            this.minAppInstances = 1;
            this.maxAppInstances = 3;
            this.maxRequestsPerSecond = 100;
            this.alarmingUpperRate = 0.7;
            this.alarmingLowerRate = 0.2;
            this.scaleDownFactor = 0.25;
            this.roundsToAverage = 10;
            this.instancesPerScaleUp = 1;
            this.messageExpiryTime = 60000;
            this.hosts = new ArrayList<String>();
            this.urlSuffixes = new HashMap<String, String>();
            this.subDomain = "__$default";
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String name) {
            this.serviceName = name;
        }

        public String getPublicIp() {
            return this.publicIp;
        }

        public void setPublic_ip(String publicIp) {
            this.publicIp = publicIp;
        }

        public String getTenantRange() {
            if (this.tenantRangeSet) {
                return this.tenantRange;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.tenantRangeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.tenantRange;
            }
            return this.tenantRange;
        }

        public String getDomain() {
            return this.domain;
        }

        public List<String> getHosts() {
            if (this.hostsSet) {
                return this.hosts;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.hostsSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.hosts;
            }
            return this.hosts;
        }

        public int getMinAppInstances() {
            if (this.minAppInstancesSet) {
                return this.minAppInstances;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.minAppInstancesSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.minAppInstances;
            }
            return this.minAppInstances;
        }

        public int getMaxAppInstances() {
            if (this.maxAppInstancesSet) {
                return this.maxAppInstances;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.maxAppInstancesSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.maxAppInstances;
            }
            return this.maxAppInstances;
        }

        public int getMaxRequestsPerSecond() {
            if (this.maxRequestsPerSecondSet) {
                return this.maxRequestsPerSecond;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.maxRequestsPerSecondSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.maxRequestsPerSecond;
            }
            return this.maxRequestsPerSecond;
        }

        public int getRoundsToAverage() {
            if (this.roundsToAverageSet) {
                return this.roundsToAverage;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.roundsToAverageSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.roundsToAverage;
            }
            return this.roundsToAverage;
        }

        public int getInstancesPerScaleUp() {
            if (this.instancesPerScaleUpSet) {
                return this.instancesPerScaleUp;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.instancesPerScaleUpSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.instancesPerScaleUp;
            }
            return this.instancesPerScaleUp;
        }

        public int getMessageExpiryTime() {
            if (this.messageExpiryTimeSet) {
                return this.messageExpiryTime;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.messageExpiryTimeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.messageExpiryTime;
            }
            return this.messageExpiryTime;
        }

        public String getSubDomain() {
            if (this.subDomainSet) {
                return this.subDomain;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.subDomainSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.subDomain;
            }
            return this.subDomain;
        }

        public void setMin_app_instances(int minAppInstances) {
            this.minAppInstances = minAppInstances;
            this.minAppInstancesSet = true;
        }

        public void setMax_app_instances(int maxAppInstances) {
            if (maxAppInstances < 1) {
                LoadBalancerConfigUtil.handleException("maxAppInstances in the autoscaler task configuration should be at least 1");
            }
            this.maxAppInstances = maxAppInstances;
            this.maxAppInstancesSet = true;
        }

        public void setAlarming_upper_rate(double rate) {
            if (rate > 0.0 && rate <= 1.0) {
                this.alarmingUpperRate = rate;
                this.alarmingUpperRateSet = true;
            }
        }

        public void setAlarming_lower_rate(double rate) {
            if (rate > 0.0 && rate <= 1.0) {
                this.alarmingLowerRate = rate;
                this.alarmingLowerRateSet = true;
            }
        }

        public void setScale_down_factor(double factor) {
            if (factor > 0.0 && factor <= 1.0) {
                this.scaleDownFactor = factor;
                this.scaleDownFactorSet = true;
            }
        }

        public void setMax_requests_per_second(int rps) {
            this.maxRequestsPerSecond = rps;
            this.maxRequestsPerSecondSet = true;
        }

        public void setRounds_to_average(int roundsToAverage) {
            this.roundsToAverage = roundsToAverage;
            this.roundsToAverageSet = true;
        }

        public void setInstances_per_scale_up(int instancesPerScaleUp) {
            if (instancesPerScaleUp < 1) {
                LoadBalancerConfigUtil.handleException("instancesPerScaleUp in the autoscaler task configuration should be at least 1");
            }
            this.instancesPerScaleUp = instancesPerScaleUp;
            this.instancesPerScaleUpSet = true;
        }

        public void setMessage_expiry_time(int messageExpiryTime) {
            if (messageExpiryTime < 1) {
                LoadBalancerConfigUtil.handleException("messageExpiryTime in the autoscaler task configuration should be at least 1");
            }
            this.messageExpiryTime = messageExpiryTime;
            this.messageExpiryTimeSet = true;
        }

        public void setHosts(String hostsStr) {
            String[] host;
            this.hosts = new ArrayList<String>();
            for (String string : host = hostsStr.split(",")) {
                if (string.isEmpty()) continue;
                this.hosts.add(string);
            }
        }

        public void setUrl_suffix(String suffix) {
            String[] suffixes = suffix.split(",");
            int count = 0;
            if (suffixes.length == this.hosts.size()) {
                for (String string : suffixes) {
                    if (string.isEmpty()) continue;
                    this.urlSuffixes.put(this.hosts.get(count), string);
                    ++count;
                }
            }
        }

        public Map<String, String> getUrl_suffix() {
            return this.urlSuffixes;
        }

        public void setTenant_range(String range) {
            this.tenantRange = range;
        }

        public void setSub_domain(String subDomain) {
            this.subDomain = subDomain;
            this.subDomainSet = true;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public boolean equals(ServiceConfiguration config) {
            return this.domain.equals(config.getDomain()) && this.subDomain.equals(config.getSubDomain());
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.domain).append((Object)this.subDomain).toHashCode();
        }

        public double getAlarmingUpperRate() {
            if (this.alarmingUpperRateSet) {
                return this.alarmingUpperRate;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.alarmingUpperRateSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.alarmingUpperRate;
            }
            return this.alarmingUpperRate;
        }

        public double getAlarmingLowerRate() {
            if (this.alarmingLowerRateSet) {
                return this.alarmingLowerRate;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.alarmingLowerRateSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.alarmingLowerRate;
            }
            return this.alarmingLowerRate;
        }

        public double getScaleDownFactor() {
            if (this.scaleDownFactorSet) {
                return this.scaleDownFactor;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.scaleDownFactorSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.scaleDownFactor;
            }
            return this.scaleDownFactor;
        }
    }

    public class LBConfiguration
    extends Configuration
    implements Serializable {
        private static final long serialVersionUID = 1357143883932816418L;
        private String elasticIP;
        private int instances;
        private boolean isAutoscaleEnabled;
        private int autoscalerTaskInterval;
        private String autoscalerServiceEpr;
        private int serverStartupDelay;
        private int sizeOfCache;
        private boolean failOver;
        private int sessionTimeOut;
        private String groupManagementAgentClass;
        private String autoscalerTaskClass;
        private String mbServerUrl;
        private boolean useEmbeddedAutoscaler;
        private String algorithm;

        public LBConfiguration() {
            this.instances = 1;
            this.autoscalerTaskInterval = 30000;
            this.serverStartupDelay = 60000;
            this.sizeOfCache = 0;
            this.sessionTimeOut = -1;
            this.useEmbeddedAutoscaler = true;
            this.algorithm = "org.apache.synapse.endpoints.algorithms.RoundRobin";
        }

        public String getElasticIP() {
            return this.elasticIP;
        }

        public int getInstances() {
            return this.instances;
        }

        public boolean isAutoscaleEnabled() {
            return this.isAutoscaleEnabled;
        }

        public boolean useEmbeddedAutoscaler() {
            return this.useEmbeddedAutoscaler;
        }

        public boolean getFailOver() {
            return this.failOver;
        }

        public String getAutoscalerServiceEpr() {
            return this.autoscalerServiceEpr;
        }

        public int getAutoscalerTaskInterval() {
            return this.autoscalerTaskInterval;
        }

        public int getServerStartupDelay() {
            return this.serverStartupDelay;
        }

        public int getSessionTimeOut() {
            return this.sessionTimeOut;
        }

        public void setElasticIP(String elasticIP) {
            this.elasticIP = LoadBalancerConfigUtil.replaceVariables(elasticIP);
        }

        public void setInstances(int instances) {
            this.instances = instances;
        }

        public void setEnable_autoscaler(String isEnabled) {
            this.isAutoscaleEnabled = Boolean.parseBoolean(isEnabled);
        }

        public void setUse_embedded_autoscaler(String use) {
            this.useEmbeddedAutoscaler = Boolean.parseBoolean(use);
        }

        public void setFail_over(String isEnabled) {
            this.failOver = Boolean.parseBoolean(isEnabled);
        }

        public void setAutoscaler_service_epr(String epr) {
            this.autoscalerServiceEpr = epr;
        }

        public void setMb_server_url(String url) {
            this.mbServerUrl = url;
        }

        public String getMbServerUrl() {
            return this.mbServerUrl;
        }

        public void setAutoscaler_task_interval(String interval) {
            this.autoscalerTaskInterval = Integer.parseInt(interval);
        }

        public void setServer_startup_delay(String delay) {
            this.serverStartupDelay = Integer.parseInt(delay);
        }

        public void setSession_timeout(String timeout) {
            this.sessionTimeOut = Integer.parseInt(timeout);
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            if (algorithm != null) {
                this.algorithm = algorithm;
            }
        }

        public int getSizeOfCache() {
            return this.sizeOfCache;
        }

        public void setSize_of_cache(int sizeOfCache) {
            this.sizeOfCache = sizeOfCache;
        }

        public String getGroupManagementAgentClass() {
            return this.groupManagementAgentClass;
        }

        public String getAutoscalerTaskClass() {
            return this.autoscalerTaskClass;
        }

        public void setGroup_mgt_agent(String groupManagementAgentClass) {
            this.groupManagementAgentClass = groupManagementAgentClass;
        }

        public void setAutoscaler_task(String autoscalerTaskClass) {
            this.autoscalerTaskClass = autoscalerTaskClass;
        }
    }

    public abstract class Configuration
    implements Serializable {
        private static final long serialVersionUID = -5433889427746551250L;
        protected String imageId = System.getenv("ami_id");
        protected String payload;
        protected boolean payloadSet;
        protected String availability_zone = "us-east-1c";
        protected boolean availabilityZoneSet;
        protected String[] security_groups = new String[]{"default"};
        protected boolean securityGroupsSet;
        protected String instance_type = "m1.large";
        protected boolean instanceTypeSet;
        protected String additional_info;

        public String getImageId() {
            return this.imageId;
        }

        public String getAdditionalInfo() {
            return this.additional_info;
        }

        public String getAvailability_zone() {
            if (this instanceof LBConfiguration) {
                return this.availability_zone;
            }
            if (this.availabilityZoneSet) {
                return this.availability_zone;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.availabilityZoneSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.availability_zone;
            }
            return this.availability_zone;
        }

        public String[] getSecurityGroups() {
            if (this instanceof LBConfiguration) {
                return this.security_groups;
            }
            if (this.securityGroupsSet) {
                return this.security_groups;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.securityGroupsSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.security_groups;
            }
            return this.security_groups;
        }

        public String getInstanceType() {
            if (this instanceof LBConfiguration) {
                return this.instance_type;
            }
            if (this.instanceTypeSet) {
                return this.instance_type;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.instanceTypeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.instance_type;
            }
            return this.instance_type;
        }

        public String getUserData() {
            if (this.payload == null) {
                this.payload = LoadBalancerConfigUtil.getUserData("resources/cluster_node.zip");
            }
            if (this instanceof LBConfiguration) {
                return this.payload;
            }
            if (this.payloadSet) {
                return this.payload;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.payloadSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.payload;
            }
            return this.payload;
        }

        public void setPayload(String payload) {
            this.payload = LoadBalancerConfigUtil.getUserData(LoadBalancerConfigUtil.replaceVariables(payload));
            this.payloadSet = true;
        }

        public void setAvailability_zone(String availabilityZone) {
            this.availability_zone = LoadBalancerConfigUtil.replaceVariables(availabilityZone);
            this.availabilityZoneSet = true;
        }

        public void setSecurity_groups(String securityGroups) {
            this.security_groups = LoadBalancerConfigUtil.replaceVariables(securityGroups).split(",");
            this.securityGroupsSet = true;
        }

        public void setInstance_type(String instanceType) {
            this.instance_type = LoadBalancerConfigUtil.replaceVariables(instanceType);
            this.instanceTypeSet = true;
        }
    }
}

