/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AxisOperation
extends AxisDescription
implements WSDLConstants {
    public static final String STYLE_RPC = "rpc";
    public static final String STYLE_MSG = "msg";
    public static final String STYLE_DOC = "doc";
    private static final Log log = LogFactory.getLog(AxisOperation.class);
    private int mep = -1;
    private boolean controlOperation = false;
    private String style = "doc";
    protected String mepURI = "http://www.w3.org/ns/wsdl/in-out";
    private MessageReceiver messageReceiver;
    private HashMap<String, ModuleConfiguration> moduleConfigmap;
    private ArrayList<String> modulerefs;
    private ArrayList<AxisMessage> faultMessages;
    private QName name;
    private ArrayList<String> wsamappingList;
    private String outputAction;
    private LinkedHashMap<String, String> faultActions = new LinkedHashMap();
    private String soapAction;

    public AxisOperation() {
        this.modulerefs = new ArrayList();
        this.moduleConfigmap = new HashMap();
        this.faultMessages = new ArrayList();
        QName tmpName = new QName(this.getClass().getName() + "_" + UIDGenerator.generateUID());
        this.setName(tmpName);
    }

    public AxisOperation(QName name) {
        this();
        this.setName(name);
    }

    public abstract void addMessage(AxisMessage var1, String var2);

    public abstract void addMessageContext(MessageContext var1, OperationContext var2) throws AxisFault;

    public abstract void addFaultMessageContext(MessageContext var1, OperationContext var2) throws AxisFault;

    public void addModule(String moduleName) {
        this.modulerefs.add(moduleName);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    @Override
    public final void onEngage(AxisModule axisModule, AxisDescription engager) throws AxisFault {
        AxisService service;
        boolean selfEngaged;
        boolean bl = selfEngaged = engager == this;
        if (selfEngaged && (service = this.getAxisService()) != null) {
            service.addModuleOperations(axisModule);
        }
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
        phaseResolver.engageModuleToOperation(this, axisModule);
    }

    @Override
    protected void onDisengage(AxisModule module) {
        AxisService service = this.getAxisService();
        if (service == null) {
            return;
        }
        AxisConfiguration axisConfiguration = service.getAxisConfiguration();
        PhaseResolver phaseResolver = new PhaseResolver(axisConfiguration);
        if (!service.isEngaged(module.getName()) && axisConfiguration != null && !axisConfiguration.isEngaged(module.getName())) {
            phaseResolver.disengageModuleFromGlobalChains(module);
        }
        phaseResolver.disengageModuleFromOperationChain(module, this);
        HashMap<QName, AxisOperation> moduleOperations = module.getOperations();
        if (moduleOperations != null) {
            for (AxisOperation operation : moduleOperations.values()) {
                service.removeOperation(operation.getName());
            }
        }
    }

    public void removeFromEngagedModuleList(AxisModule module) {
        try {
            this.disengageModule(module);
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
        }
    }

    public OperationContext findForExistingOperationContext(MessageContext msgContext) throws AxisFault {
        ConfigurationContext configContext;
        OperationContext operationContext = msgContext.getOperationContext();
        if (operationContext != null) {
            return operationContext;
        }
        if (null != msgContext.getRelatesTo() && null == (operationContext = (configContext = msgContext.getConfigurationContext()).getOperationContext(msgContext.getRelatesTo().getValue())) && log.isDebugEnabled()) {
            log.debug((Object)(msgContext.getLogIDString() + " Cannot correlate inbound message RelatesTo value [" + msgContext.getRelatesTo() + "] to in-progree MEP"));
        }
        return operationContext;
    }

    public OperationContext findOperationContext(MessageContext msgContext, ServiceContext serviceContext) throws AxisFault {
        OperationContext operationContext;
        if (null == msgContext.getRelatesTo()) {
            operationContext = serviceContext.createOperationContext(this);
        } else {
            ConfigurationContext configContext = msgContext.getConfigurationContext();
            operationContext = configContext.getOperationContext(msgContext.getRelatesTo().getValue());
            if (null == operationContext) {
                throw new AxisFault(Messages.getMessage("cannotCorrelateMsg", this.name.toString(), msgContext.getRelatesTo().getValue()));
            }
        }
        return operationContext;
    }

    public void registerOperationContext(MessageContext msgContext, OperationContext operationContext) throws AxisFault {
        msgContext.setAxisOperation(this);
        msgContext.getConfigurationContext().registerOperationContext(msgContext.getMessageID(), operationContext);
        operationContext.addMessageContext(msgContext);
        msgContext.setOperationContext(operationContext);
        if (operationContext.isComplete()) {
            operationContext.cleanup();
        }
    }

    public void registerMessageContext(MessageContext msgContext, OperationContext operationContext) throws AxisFault {
        msgContext.setAxisOperation(this);
        operationContext.addMessageContext(msgContext);
        msgContext.setOperationContext(operationContext);
        if (operationContext.isComplete()) {
            operationContext.cleanup();
        }
    }

    public int getAxisSpecificMEPConstant() {
        if (this.mep != -1) {
            return this.mep;
        }
        int temp = -1;
        if ("http://www.w3.org/ns/wsdl/in-out".equals(this.mepURI)) {
            temp = 12;
        } else if ("http://www.w3.org/ns/wsdl/in-only".equals(this.mepURI)) {
            temp = 10;
        } else if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(this.mepURI)) {
            temp = 13;
        } else if ("http://www.w3.org/ns/wsdl/out-in".equals(this.mepURI)) {
            temp = 16;
        } else if ("http://www.w3.org/ns/wsdl/out-only".equals(this.mepURI)) {
            temp = 14;
        } else if ("http://www.w3.org/ns/wsdl/out-opt-in".equals(this.mepURI)) {
            temp = 17;
        } else if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(this.mepURI)) {
            temp = 11;
        } else if ("http://www.w3.org/ns/wsdl/robust-out-only".equals(this.mepURI)) {
            temp = 15;
        }
        if (temp == -1) {
            throw new AxisError(Messages.getMessage("mepmappingerror"));
        }
        this.mep = temp;
        return this.mep;
    }

    public abstract AxisMessage getMessage(String var1);

    public String getMessageExchangePattern() {
        return this.mepURI;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return this.moduleConfigmap.get(moduleName);
    }

    public ArrayList<String> getModuleRefs() {
        return this.modulerefs;
    }

    public QName getName() {
        return this.name;
    }

    public abstract ArrayList getPhasesInFaultFlow();

    public abstract ArrayList getPhasesOutFaultFlow();

    public abstract ArrayList getPhasesOutFlow();

    public abstract ArrayList getRemainingPhasesInFlow();

    public String getStyle() {
        return this.style;
    }

    public ArrayList<String> getWSAMappingList() {
        return this.wsamappingList;
    }

    public boolean isControlOperation() {
        return this.controlOperation;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        boolean locked = false;
        if (this.getParent() != null) {
            locked = this.getParent().isParameterLocked(parameterName);
        }
        if (locked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setControlOperation(boolean controlOperation) {
        this.controlOperation = controlOperation;
    }

    public void setMessageExchangePattern(String mepURI) {
        this.mepURI = mepURI;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public abstract void setPhasesInFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFlow(ArrayList var1);

    public abstract void setRemainingPhasesInFlow(ArrayList var1);

    public void setStyle(String style) {
        if (!"".equals(style)) {
            this.style = style;
        }
    }

    public void setWsamappingList(ArrayList wsamappingList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setWsamappinglist");
        }
        this.wsamappingList = wsamappingList;
        if (wsamappingList != null && !wsamappingList.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)(" wsa action is " + (String)wsamappingList.get(0)));
        }
    }

    public abstract OperationClient createClient(ServiceContext var1, Options var2);

    @Override
    public Object getKey() {
        return this.name;
    }

    public ArrayList<AxisMessage> getFaultMessages() {
        return this.faultMessages;
    }

    public void setFaultMessages(AxisMessage faultMessage) {
        faultMessage.setParent(this);
        this.faultMessages.add(faultMessage);
        if (this.getFaultAction(faultMessage.getName()) == null) {
            this.addFaultAction(faultMessage.getName(), "urn:" + this.name.getLocalPart() + faultMessage.getName());
        }
    }

    public void setSoapAction(String soapAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: AxisOperation::setSoapAction, previous soapAction: " + this.soapAction + " updated soapAction: " + soapAction));
        }
        this.soapAction = soapAction;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AxisOperation::setSoapAction");
        }
    }

    public String getInputAction() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry: AxisOperation::getInputAction");
        }
        String result = null;
        if (this.soapAction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Debug: AxisOperation::getInputAction - using soapAction");
                if (this.wsamappingList != null && !this.wsamappingList.isEmpty()) {
                    log.debug((Object)(" but WSA map indicates " + this.wsamappingList.get(0)));
                }
            }
            result = this.soapAction;
        } else if (this.wsamappingList != null && !this.wsamappingList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Debug: AxisOperation::getInputAction - using wsamappingList");
            }
            result = this.wsamappingList.get(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: AxisOperation::getInputAction " + result));
        }
        return result;
    }

    public String getOutputAction() {
        return this.outputAction;
    }

    public void setOutputAction(String act) {
        this.outputAction = act;
    }

    public void addFaultAction(String faultName, String action) {
        this.faultActions.put(faultName, action);
    }

    public void removeFaultAction(String faultName) {
        this.faultActions.remove(faultName);
    }

    public String getFaultAction(String faultName) {
        return this.faultActions.get(faultName);
    }

    public String[] getFaultActionNames() {
        Set<String> keys = this.faultActions.keySet();
        String[] faultActionNames = new String[keys.size()];
        faultActionNames = keys.toArray(faultActionNames);
        return faultActionNames;
    }

    public String getFaultAction() {
        String result = null;
        Iterator<String> iter = this.faultActions.values().iterator();
        if (iter.hasNext()) {
            result = iter.next();
        }
        return result;
    }

    public Iterator<AxisMessage> getMessages() {
        return this.getChildren();
    }

    public AxisService getAxisService() {
        return (AxisService)this.getParent();
    }

    public String getSoapAction() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AxisOperation::getSoapAction " + this.soapAction));
        }
        return this.soapAction;
    }
}

