/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.messages;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.messages.ClusterDomain;
import org.apache.stratos.cartridge.messages.ClusterDomainManager;

public class CreateClusterDomainMessage
extends ClusteringMessage {
    private static final Log log = LogFactory.getLog(CreateClusterDomainMessage.class);
    public static final String CLUSTER_DOMAIN_MANAGER = "cluster.domain.manager";
    private String service;
    private String clusterDomain;
    private String hostName;
    private String tenantRange;
    private int minInstances;
    private int maxInstances;
    private int maxRequestsPerSecond;
    private int roundsToAverage;
    private double alarmingUpperRate;
    private double alarmingLowerRate;
    private double scaleDownFactor;

    public CreateClusterDomainMessage(String service, String clusterDomain, String hostName, String tenantRange, int minInstances, int maxInstances, int maxRequestsPerSecond, int roundsToAverage, double alarmingUpperRate, double alarmingLowerRate, double scaleDownFactor) {
        this.service = service;
        this.clusterDomain = clusterDomain;
        this.hostName = hostName;
        this.tenantRange = tenantRange;
        this.minInstances = minInstances;
        this.maxInstances = maxInstances;
        this.maxRequestsPerSecond = maxRequestsPerSecond;
        this.roundsToAverage = roundsToAverage;
        this.alarmingUpperRate = alarmingUpperRate;
        this.alarmingLowerRate = alarmingLowerRate;
        this.scaleDownFactor = scaleDownFactor;
    }

    public ClusteringCommand getResponse() {
        return new ClusteringCommand(){

            public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
                log.info((Object)"Received response to CreateClusterDomainMessage");
            }
        };
    }

    public void execute(final ConfigurationContext configurationContext) throws ClusteringFault {
        log.info((Object)("Received ***" + (Object)((Object)this)));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ClusterDomainManager clusterDomainManager = (ClusterDomainManager)configurationContext.getProperty(CreateClusterDomainMessage.CLUSTER_DOMAIN_MANAGER);
                if (clusterDomainManager != null) {
                    clusterDomainManager.addClusterDomain(this.createClusterDomain());
                } else {
                    log.warn((Object)"cluster.domain.manager has not been defined in ConfigurationContext");
                }
            }

            private ClusterDomain createClusterDomain() {
                ClusterDomain clusterDomainObj = new ClusterDomain();
                clusterDomainObj.setDomain(CreateClusterDomainMessage.this.clusterDomain);
                clusterDomainObj.setHostName(CreateClusterDomainMessage.this.hostName);
                clusterDomainObj.setMaxInstances(CreateClusterDomainMessage.this.maxInstances);
                clusterDomainObj.setMinInstances(CreateClusterDomainMessage.this.minInstances);
                clusterDomainObj.setSubDomain(null);
                clusterDomainObj.setTenantRange(CreateClusterDomainMessage.this.tenantRange);
                clusterDomainObj.setServiceName(CreateClusterDomainMessage.this.service);
                clusterDomainObj.setMaxRequestsPerSecond(CreateClusterDomainMessage.this.maxRequestsPerSecond);
                clusterDomainObj.setRoundsToAverage(CreateClusterDomainMessage.this.roundsToAverage);
                clusterDomainObj.setAlarmingUpperRate(CreateClusterDomainMessage.this.alarmingUpperRate);
                clusterDomainObj.setAlarmingLowerRate(CreateClusterDomainMessage.this.alarmingLowerRate);
                clusterDomainObj.setScaleDownFactor(CreateClusterDomainMessage.this.scaleDownFactor);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cluster Domain is created with minInstances:" + CreateClusterDomainMessage.this.minInstances + ", maxInstances: " + CreateClusterDomainMessage.this.maxInstances));
                }
                return clusterDomainObj;
            }
        };
        new Thread(runnable).start();
    }

    public String toString() {
        return "CreateClusterDomainMessage{service='" + this.service + '\'' + ", clusterDomain='" + this.clusterDomain + '\'' + ", hostName='" + this.hostName + '\'' + ", tenantId=" + this.tenantRange + '}';
    }
}

