/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.submit.command;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.submit.dependency.AetherUtils;
import org.apache.storm.submit.dependency.DependencyResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.json.simple.JSONValue;

public class DependencyResolverMain {
    public static void main(String[] args) {
        List<RemoteRepository> repositories;
        if (args.length < 1) {
            throw new IllegalArgumentException("artifacts must be presented.");
        }
        String artifactsArg = args[0];
        System.err.println("DependencyResolver input - artifacts: " + artifactsArg);
        List<Dependency> dependencies = DependencyResolverMain.parseArtifactArgs(artifactsArg);
        if (args.length > 1) {
            String remoteRepositoryArg = args[1];
            System.err.println("DependencyResolver input - repositories: " + remoteRepositoryArg);
            repositories = DependencyResolverMain.parseRemoteRepositoryArgs(remoteRepositoryArg);
        } else {
            repositories = Collections.emptyList();
        }
        try {
            String localMavenRepoPath = DependencyResolverMain.getOrDefaultLocalMavenRepositoryPath("local-repo");
            Files.createDirectories(new File(localMavenRepoPath).toPath(), new FileAttribute[0]);
            DependencyResolver resolver = new DependencyResolver(localMavenRepoPath, repositories);
            List<ArtifactResult> artifactResults = resolver.resolve(dependencies);
            Iterable<ArtifactResult> missingArtifacts = DependencyResolverMain.filterMissingArtifacts(artifactResults);
            if (missingArtifacts.iterator().hasNext()) {
                DependencyResolverMain.printMissingArtifactsToSysErr(missingArtifacts);
                throw new RuntimeException("Some artifacts are not resolved");
            }
            System.out.println(JSONValue.toJSONString(DependencyResolverMain.transformArtifactResultToArtifactToPaths(artifactResults)));
            System.out.flush();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Iterable<ArtifactResult> filterMissingArtifacts(List<ArtifactResult> artifactResults) {
        return Iterables.filter(artifactResults, new Predicate<ArtifactResult>(){

            @Override
            public boolean apply(ArtifactResult artifactResult) {
                return artifactResult.isMissing();
            }
        });
    }

    private static void printMissingArtifactsToSysErr(Iterable<ArtifactResult> missingArtifacts) {
        for (ArtifactResult artifactResult : missingArtifacts) {
            System.err.println("ArtifactResult : " + artifactResult + " / Errors : " + artifactResult.getExceptions());
        }
    }

    private static List<Dependency> parseArtifactArgs(String artifactArgs) {
        List<String> artifacts = Arrays.asList(artifactArgs.split(","));
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(artifacts.size());
        for (String artifactOpt : artifacts) {
            if (artifactOpt.trim().isEmpty()) continue;
            dependencies.add(AetherUtils.parseDependency(artifactOpt));
        }
        return dependencies;
    }

    private static List<RemoteRepository> parseRemoteRepositoryArgs(String remoteRepositoryArg) {
        List<String> repositories = Arrays.asList(remoteRepositoryArg.split(","));
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>(repositories.size());
        for (String repositoryOpt : repositories) {
            if (repositoryOpt.trim().isEmpty()) continue;
            remoteRepositories.add(AetherUtils.parseRemoteRepository(repositoryOpt));
        }
        return remoteRepositories;
    }

    private static Map<String, String> transformArtifactResultToArtifactToPaths(List<ArtifactResult> artifactResults) {
        LinkedHashMap<String, String> artifactToPath = new LinkedHashMap<String, String>();
        for (ArtifactResult artifactResult : artifactResults) {
            Artifact artifact = artifactResult.getArtifact();
            artifactToPath.put(AetherUtils.artifactToString(artifact), artifact.getFile().getAbsolutePath());
        }
        return artifactToPath;
    }

    private static String getOrDefaultLocalMavenRepositoryPath(String defaultPath) {
        Path localMavenRepoPath;
        String localMavenRepoPathStr = DependencyResolverMain.getLocalMavenRepositoryPath();
        if (StringUtils.isNotEmpty(localMavenRepoPathStr) && Files.exists(localMavenRepoPath = new File(localMavenRepoPathStr).toPath(), new LinkOption[0]) && Files.isDirectory(localMavenRepoPath, new LinkOption[0])) {
            return localMavenRepoPathStr;
        }
        return defaultPath;
    }

    private static String getLocalMavenRepositoryPath() {
        String userHome = System.getProperty("user.home");
        if (StringUtils.isNotEmpty(userHome)) {
            return userHome + File.separator + ".m2" + File.separator + "repository";
        }
        return null;
    }
}

