/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.sql.runtime.ISqlStreamsDataSource;
import org.apache.storm.streams.Pair;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestUtils {
    public static long monotonicNow() {
        long NANOSECONDS_PER_MILLISECOND = 1000000L;
        return System.nanoTime() / 1000000L;
    }

    public static class MockSqlStreamsInsertNestedDataSource
    extends MockSqlStreamsNestedDataSource {
        @Override
        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlStreamsNestedDataSource
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            ArrayList<Values> records = new ArrayList<Values>();
            Fields outputFields = new Fields(new String[]{"ID", "MAPFIELD", "NESTEDMAPFIELD", "ARRAYFIELD"});
            List<Integer> ints = Arrays.asList(100, 200, 300);
            for (int i = 0; i < 5; ++i) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("b", i);
                map.put("c", i * i);
                HashMap<String, HashMap<String, Integer>> mm = new HashMap<String, HashMap<String, Integer>>();
                mm.put("a", map);
                records.add(new Values(new Object[]{i, map, mm, ints}));
            }
            return new MockSpout(records, outputFields);
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockSqlStreamsInsertJoinDataSourceDept
    extends MockSqlStreamsJoinDataSourceDept {
        @Override
        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlStreamsJoinDataSourceDept
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            ArrayList<Values> records = new ArrayList<Values>();
            Fields outputFields = new Fields(new String[]{"DEPTID", "DEPTNAME"});
            for (int i = 0; i < 5; ++i) {
                records.add(new Values(new Object[]{i, "dept-" + i}));
            }
            return new MockSpout(records, outputFields);
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockSqlStreamsInsertJoinDataSourceEmp
    extends MockSqlStreamsJoinDataSourceEmp {
        @Override
        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlStreamsJoinDataSourceEmp
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            int i;
            ArrayList<Values> records = new ArrayList<Values>();
            Fields outputFields = new Fields(new String[]{"EMPID", "EMPNAME", "DEPTID"});
            for (i = 0; i < 5; ++i) {
                records.add(new Values(new Object[]{i, "emp-" + i, i % 2}));
            }
            for (i = 10; i < 15; ++i) {
                records.add(new Values(new Object[]{i, "emp-" + i, i}));
            }
            return new MockSpout(records, outputFields);
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockSqlStreamsInsertGroupedDataSource
    extends MockSqlStreamsGroupedDataSource {
        @Override
        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlStreamsGroupedDataSource
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            ArrayList<Values> records = new ArrayList<Values>();
            for (int i = 0; i < 5; ++i) {
                records.add(new Values(new Object[]{i, 0, "x", "y", 5 - i, i * 10}));
            }
            Fields outputFields = new Fields(new String[]{"ID", "GRPID", "NAME", "ADDR", "AGE", "SCORE"});
            return new MockSpout(records, outputFields);
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockSqlStreamsInsertDataSource
    extends MockSqlStreamsNestedDataSource {
        @Override
        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlStreamsDataSource
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            ArrayList<Values> records = new ArrayList<Values>();
            records.add(new Values(new Object[]{0, "a", "y"}));
            records.add(new Values(new Object[]{1, "ab", "y"}));
            records.add(new Values(new Object[]{2, "abc", "y"}));
            records.add(new Values(new Object[]{3, "abcd", "y"}));
            records.add(new Values(new Object[]{4, "abcde", "y"}));
            Fields outputFields = new Fields(new String[]{"ID", "NAME", "ADDR"});
            return new MockSpout(records, outputFields);
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockSqlStreamsOutputDataSource
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public IRichBolt getConsumer() {
            return new MockInsertBolt();
        }
    }

    public static class MockSqlExprDataSource
    implements ISqlStreamsDataSource {
        public IRichSpout getProducer() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public IRichBolt getConsumer() {
            return new MockBolt();
        }
    }

    public static class MockInsertBolt
    extends BaseRichBolt {
        private static final transient List<Pair<Object, Values>> VALUES = new ArrayList<Pair<Object, Values>>();

        public static List<Pair<Object, Values>> getCollectedValues() {
            return VALUES;
        }

        public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        }

        public void execute(Tuple input) {
            VALUES.add((Pair<Object, Values>)Pair.of((Object)input.getValue(0), (Object)((Values)input.getValue(1))));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
        }
    }

    public static class MockBolt
    extends BaseRichBolt {
        private static final transient List<Values> VALUES = new ArrayList<Values>();

        public static List<Values> getCollectedValues() {
            return VALUES;
        }

        public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        }

        public void execute(Tuple input) {
            VALUES.add((Values)input.getValue(0));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
        }
    }

    public static class MockSpout
    extends BaseRichSpout {
        private final List<Values> records;
        private final Fields outputFields;
        private boolean emitted = false;
        private SpoutOutputCollector collector;

        public MockSpout(List<Values> records, Fields outputFields) {
            this.records = records;
            this.outputFields = outputFields;
        }

        public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
            this.collector = collector;
        }

        public void nextTuple() {
            if (this.emitted) {
                return;
            }
            for (Values r : this.records) {
                this.collector.emit((List)r);
            }
            this.emitted = true;
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(this.outputFields);
        }
    }

    public static class TopN {
        public static PriorityQueue<Integer> init() {
            return new PriorityQueue<Integer>();
        }

        public static PriorityQueue<Integer> add(PriorityQueue<Integer> accumulator, Integer n, Integer val) {
            if (n <= 0) {
                return accumulator;
            }
            if (accumulator.size() >= n) {
                if (val > accumulator.peek()) {
                    accumulator.remove();
                    accumulator.add(val);
                }
            } else {
                accumulator.add(val);
            }
            return accumulator;
        }

        public static List<Integer> result(PriorityQueue<Integer> accumulator) {
            ArrayList<Integer> res = new ArrayList<Integer>(accumulator);
            Collections.reverse(res);
            return res;
        }
    }

    public static class MyConcat {
        public static String init() {
            return "";
        }

        public static String add(String accumulator, String val) {
            return accumulator + val;
        }

        public static String result(String accumulator) {
            return accumulator;
        }
    }

    public static class MyPlus {
        public static Integer evaluate(Integer x, Integer y) {
            return x + y;
        }
    }

    public static final class MockBoltExtension
    implements BeforeEachCallback {
        public void beforeEach(ExtensionContext arg0) throws Exception {
            MockBolt.getCollectedValues().clear();
        }
    }

    public static final class MockInsertBoltExtension
    implements BeforeEachCallback {
        public void beforeEach(ExtensionContext ctx) throws Exception {
            MockInsertBolt.getCollectedValues().clear();
        }
    }
}

