/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.sql.runtime.serde.json.JsonScheme;
import org.apache.storm.sql.runtime.serde.json.JsonSerializer;
import org.apache.storm.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonRepresentation {
    @Test
    public void testJsonScheme() {
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"ID", "val"});
        String s = "{\"ID\": 1, \"val\": \"2\"}";
        JsonScheme scheme = new JsonScheme((List)fields);
        List o = scheme.deserialize(ByteBuffer.wrap("{\"ID\": 1, \"val\": \"2\"}".getBytes(Charset.defaultCharset())));
        Assert.assertArrayEquals((Object[])new Object[]{1, "2"}, (Object[])o.toArray());
    }

    @Test
    public void testJsonSerializer() {
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"ID", "val"});
        ArrayList o = Lists.newArrayList((Object[])new Object[]{1, "2"});
        JsonSerializer s = new JsonSerializer((List)fields);
        ByteBuffer buf = s.write((List)o, null);
        byte[] b = Utils.toByteArray((ByteBuffer)buf);
        Assert.assertEquals((Object)"{\"ID\":1,\"val\":\"2\"}", (Object)new String(b));
    }
}

