/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.sql.runtime.serde.avro.AvroScheme;
import org.apache.storm.sql.runtime.serde.avro.AvroSerializer;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroSerializer {
    private static final String schemaString = "{\"type\":\"record\",\"name\":\"avrotest\",\"fields\":[{\"name\":\"ID\",\"type\":\"int\"},{ \"name\":\"val\", \"type\":\"string\" }]}";
    private static final String schemaString1 = "{\"type\":\"record\",\"name\":\"avrotest\",\"fields\":[{\"name\":\"ID\",\"type\":\"int\"},{ \"type\":{\"type\":\"map\",\"values\": \"long\"}, \"name\":\"val1\" },{ \"type\":{\"type\":\"array\",\"items\": \"string\"}, \"name\":\"val2\" }]}";

    @Test
    public void testAvroSchemeAndSerializer() {
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"ID", "val"});
        ArrayList o = Lists.newArrayList((Object[])new Object[]{1, "2"});
        AvroSerializer serializer = new AvroSerializer(schemaString, (List)fields);
        ByteBuffer byteBuffer = serializer.write((List)o, null);
        AvroScheme scheme = new AvroScheme(schemaString, (List)fields);
        Assert.assertArrayEquals((Object[])o.toArray(), (Object[])scheme.deserialize(byteBuffer).toArray());
    }

    @Test
    public void testAvroComplexSchemeAndSerializer() {
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"ID", "val1", "val2"});
        HashMap mp = Maps.newHashMap();
        mp.put("l1", 1234L);
        mp.put("l2", 56789L);
        ArrayList ls = Lists.newArrayList((Object[])new String[]{"s1", "s2"});
        ArrayList o = Lists.newArrayList((Object[])new Object[]{1, mp, ls});
        AvroSerializer serializer = new AvroSerializer(schemaString1, (List)fields);
        ByteBuffer byteBuffer = serializer.write((List)o, null);
        AvroScheme scheme = new AvroScheme(schemaString1, (List)fields);
        Assert.assertArrayEquals((Object[])o.toArray(), (Object[])scheme.deserialize(byteBuffer).toArray());
    }
}

