/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.mongodb;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.mongodb.bolt.MongoInsertBolt;
import org.apache.storm.mongodb.common.mapper.MongoMapper;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlStreamsDataSource;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;
import org.bson.Document;

public class MongoDataSourcesProvider
implements DataSourcesProvider {
    public static final String SCHEME_NAME = "mongodb";
    public static final String VALUE_SERIALIZED_FIELD = "ser.field";
    public static final String TRIDENT_VALUE_SERIALIZED_FIELD = "trident.ser.field";
    public static final String DEFAULT_VALUE_SERIALIZED_FIELD = "tridentSerField";
    public static final String COLLECTION_NAME = "collection.name";

    public String scheme() {
        return SCHEME_NAME;
    }

    public ISqlStreamsDataSource constructStreams(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        List fieldNames = FieldInfoUtils.getFieldNames(fields);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)properties, (List)fieldNames);
        return new MongoStreamsDataSource(uri.toString(), properties, serializer);
    }

    private static class SqlMongoMapper
    implements MongoMapper {
        private final String serField;
        private final IOutputSerializer serializer;

        private SqlMongoMapper(String serField, IOutputSerializer serializer) {
            this.serField = serField;
            this.serializer = serializer;
        }

        public Document toDocument(ITuple tuple) {
            Document document = new Document();
            Values values = (Values)tuple.getValue(1);
            byte[] array = this.serializer.write((List)values, null).array();
            document.append(this.serField, (Object)array);
            return document;
        }

        public Document toDocumentByKeys(List<Object> keys) {
            return null;
        }
    }

    private static class MongoStreamsDataSource
    implements ISqlStreamsDataSource {
        private final String url;
        private final Properties props;
        private final IOutputSerializer serializer;

        private MongoStreamsDataSource(String url, Properties props, IOutputSerializer serializer) {
            this.url = url;
            this.props = props;
            this.serializer = serializer;
        }

        public IRichSpout getProducer() {
            throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide Producer");
        }

        public IRichBolt getConsumer() {
            Preconditions.checkArgument((!this.props.isEmpty() ? 1 : 0) != 0, (Object)"Writable MongoDB must contain collection config");
            String serField = this.props.contains(MongoDataSourcesProvider.VALUE_SERIALIZED_FIELD) ? this.props.getProperty(MongoDataSourcesProvider.VALUE_SERIALIZED_FIELD) : (this.props.contains(MongoDataSourcesProvider.TRIDENT_VALUE_SERIALIZED_FIELD) ? this.props.getProperty(MongoDataSourcesProvider.TRIDENT_VALUE_SERIALIZED_FIELD) : MongoDataSourcesProvider.DEFAULT_VALUE_SERIALIZED_FIELD);
            SqlMongoMapper mapper = new SqlMongoMapper(serField, this.serializer);
            return new MongoInsertBolt(this.url, this.props.getProperty(MongoDataSourcesProvider.COLLECTION_NAME), (MongoMapper)mapper);
        }
    }
}

