/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.spout.Scheme;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class JsonScheme
implements Scheme {
    private final List<String> fields;

    JsonScheme(List<String> fields) {
        this.fields = fields;
    }

    public List<Object> deserialize(ByteBuffer ser) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            HashMap map = (HashMap)mapper.readValue(Utils.toByteArray((ByteBuffer)ser), HashMap.class);
            ArrayList<Object> list = new ArrayList<Object>();
            for (String f : this.fields) {
                list.add(map.get(f));
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Fields getOutputFields() {
        return new Fields(this.fields);
    }
}

