/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.bolt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.storm.Config;
import org.apache.storm.hive.bolt.HiveBolt;
import org.apache.storm.hive.bolt.HiveSetupUtil;
import org.apache.storm.hive.bolt.mapper.DelimitedRecordHiveMapper;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.hive.bolt.mapper.JsonRecordHiveMapper;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.hive.common.HiveWriter;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.MockTupleHelpers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHiveBolt {
    static final String dbName = "testdb";
    static final String tblName = "test_table";
    static final String dbName1 = "testdb1";
    static final String tblName1 = "test_table1";
    static final String PART1_NAME = "city";
    static final String PART2_NAME = "state";
    static final String[] partNames = new String[]{"city", "state"};
    private static final String COL1 = "id";
    private static final String COL2 = "msg";
    private static final Logger LOG = LoggerFactory.getLogger(HiveBolt.class);
    final String partitionVals = "sunnyvale,ca";
    final String[] colNames = new String[]{"id", "msg"};
    final String[] colNames1 = new String[]{"msg", "id"};
    final String metaStoreURI;
    private final HiveConf conf;
    private String[] colTypes = new String[]{"int", "string"};
    private Config config = new Config();
    private TestingHiveBolt bolt;
    private ObjectMapper objectMapper = new ObjectMapper();
    @Mock
    private OutputCollector collector;

    public TestHiveBolt() throws Exception {
        this.metaStoreURI = null;
        this.conf = HiveSetupUtil.getHiveConf();
        TxnDbUtil.setConfValues((Configuration)this.conf);
        if (this.metaStoreURI != null) {
            this.conf.setVar(HiveConf.ConfVars.METASTOREURIS, this.metaStoreURI);
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testWithByteArrayIdandMessage() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        String city = "sunnyvale";
        String state = "ca";
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 4; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            this.bolt.execute(tuple);
            tupleSet.add(tuple);
        }
        ArrayList partVals = Lists.newArrayList((Object[])new String[]{city, state});
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        Assertions.assertEquals((int)4, (int)this.bolt.getRecordWritten(partVals).size());
        this.bolt.cleanup();
    }

    @Test
    public void testWithoutPartitions() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName1, tblName1, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2)).withAutoCreatePartitions(Boolean.valueOf(false));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        String city = "sunnyvale";
        String state = "ca";
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 4; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            this.bolt.execute(tuple);
            tupleSet.add(tuple);
        }
        List<String> partVals = Collections.emptyList();
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        List<byte[]> recordWritten = this.bolt.getRecordWritten(partVals);
        Assertions.assertNotNull(recordWritten);
        Assertions.assertEquals((int)4, (int)recordWritten.size());
        this.bolt.cleanup();
    }

    @Test
    public void testWithTimeformat() throws Exception {
        String timeFormat = "yyyy/MM/dd";
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withTimeAsPartitionField(timeFormat);
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName1, tblName1, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1)).withMaxOpenConnections(Integer.valueOf(1));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        Date d = new Date();
        SimpleDateFormat parseDate = new SimpleDateFormat(timeFormat);
        String today = parseDate.format(d.getTime());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = 0; i < 2; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, null, null);
            tuples.add(tuple);
            this.bolt.execute(tuple);
        }
        for (Tuple t : tuples) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        ArrayList partVals = Lists.newArrayList((Object[])new String[]{today});
        List<byte[]> recordsWritten = this.bolt.getRecordWritten(partVals);
        Assertions.assertNotNull(recordsWritten);
        Assertions.assertEquals((int)2, (int)recordsWritten.size());
        byte[] mapped = this.generateDelimiteredRecord(Lists.newArrayList((Object[])new Serializable[]{id, msg}), mapper.getFieldDelimiter());
        for (byte[] record : recordsWritten) {
            Assertions.assertArrayEquals((byte[])mapped, (byte[])record);
        }
        this.bolt.cleanup();
    }

    @Test
    public void testData() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Integer id = 1;
        String msg = "SJC";
        String city = "Sunnyvale";
        String state = "CA";
        Tuple tuple1 = this.generateTestTuple(id, msg, city, state);
        this.bolt.execute(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        ArrayList partVals = Lists.newArrayList((Object[])new String[]{city, state});
        List<byte[]> recordsWritten = this.bolt.getRecordWritten(partVals);
        Assertions.assertNotNull(recordsWritten);
        Assertions.assertEquals((int)1, (int)recordsWritten.size());
        byte[] mapped = this.generateDelimiteredRecord(Lists.newArrayList((Object[])new Serializable[]{id, msg}), mapper.getFieldDelimiter());
        Assertions.assertArrayEquals((byte[])mapped, (byte[])recordsWritten.get(0));
        this.bolt.cleanup();
    }

    @Test
    public void testJsonWriter() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 1;
        String msg = "SJC";
        String city = "Sunnyvale";
        String state = "CA";
        Tuple tuple1 = this.generateTestTuple(id, msg, city, state);
        this.bolt.execute(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        ArrayList partVals = Lists.newArrayList((Object[])new String[]{city, state});
        List<byte[]> recordsWritten = this.bolt.getRecordWritten(partVals);
        Assertions.assertNotNull(recordsWritten);
        Assertions.assertEquals((int)1, (int)recordsWritten.size());
        byte[] written = recordsWritten.get(0);
        Map writtenMap = (Map)this.objectMapper.readValue(new String(written), new TypeReference<Map<String, ?>>(){});
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put(COL1, id);
        expected.put(COL2, msg);
        Assertions.assertEquals(expected, (Object)writtenMap);
        this.bolt.cleanup();
    }

    @Test
    public void testNoAcksUntilFlushed() {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        this.bolt.execute(tuple1);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.collector});
        this.bolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple2);
        this.bolt.cleanup();
    }

    @Test
    public void testNoAcksIfFlushFails() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        FlushFailureHiveBolt failingBolt = new FlushFailureHiveBolt(hiveOptions);
        failingBolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        failingBolt.execute(tuple1);
        failingBolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple2);
        failingBolt.cleanup();
    }

    @Test
    public void testTickTuple() {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        this.bolt.execute(tuple1);
        Tuple mockTick = MockTupleHelpers.mockTickTuple();
        this.bolt.execute(mockTick);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        this.bolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple2);
        this.bolt.cleanup();
    }

    @Test
    public void testNoTickEmptyBatches() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple mockTick = MockTupleHelpers.mockTickTuple();
        this.bolt.execute(mockTick);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.collector});
        this.bolt.cleanup();
    }

    @Test
    public void testMultiPartitionTuples() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(10));
        this.bolt = new TestingHiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Integer id = 1;
        String msg = "test";
        String city = "San Jose";
        String state = "CA";
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = 0; i < 100; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            tuples.add(tuple);
            this.bolt.execute(tuple);
        }
        for (Tuple t : tuples) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        ArrayList partVals = Lists.newArrayList((Object[])new String[]{city, state});
        List<byte[]> recordsWritten = this.bolt.getRecordWritten(partVals);
        Assertions.assertNotNull(recordsWritten);
        Assertions.assertEquals((int)100, (int)recordsWritten.size());
        byte[] mapped = this.generateDelimiteredRecord(Lists.newArrayList((Object[])new Serializable[]{id, msg}), mapper.getFieldDelimiter());
        for (byte[] record : recordsWritten) {
            Assertions.assertArrayEquals((byte[])mapped, (byte[])record);
        }
        this.bolt.cleanup();
    }

    private Tuple generateTestTuple(Object id, Object msg, Object city, Object state) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{TestHiveBolt.COL1, TestHiveBolt.COL2, TestHiveBolt.PART1_NAME, TestHiveBolt.PART2_NAME});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{id, msg, city, state}), "", 1, "");
    }

    private byte[] generateDelimiteredRecord(List<?> values, String fieldDelimiter) {
        StringBuilder builder = new StringBuilder();
        for (Object value : values) {
            builder.append(value);
            builder.append(fieldDelimiter);
        }
        return builder.toString().getBytes();
    }

    private static class FlushFailureHiveBolt
    extends TestingHiveBolt {
        public FlushFailureHiveBolt(HiveOptions options) {
            super(options);
        }

        void flushAllWriters(boolean rollToNext) throws HiveWriter.CommitFailure, HiveWriter.TxnBatchFailure, HiveWriter.TxnFailure, InterruptedException {
            if (rollToNext) {
                throw new InterruptedException();
            }
            super.flushAllWriters(false);
        }
    }

    private static class TestingHiveBolt
    extends HiveBolt {
        protected Map<List<String>, List<byte[]>> partitionValuesToWrittenRecords = new HashMap<List<String>, List<byte[]>>();

        public TestingHiveBolt(HiveOptions options) {
            super(options);
        }

        HiveWriter getOrCreateWriter(final HiveEndPoint endPoint) throws HiveWriter.ConnectFailure, InterruptedException {
            HiveWriter writer = (HiveWriter)this.allWriters.get(endPoint);
            if (writer == null) {
                writer = (HiveWriter)Mockito.mock(HiveWriter.class);
                try {
                    ((HiveWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                        public Void answer(InvocationOnMock invocation) throws Throwable {
                            Object[] arguments = invocation.getArguments();
                            ArrayList partitionVals = endPoint.partitionVals;
                            List<byte[]> writtenRecords = partitionValuesToWrittenRecords.get(partitionVals);
                            if (writtenRecords == null) {
                                writtenRecords = new ArrayList<byte[]>();
                                partitionValuesToWrittenRecords.put(partitionVals, writtenRecords);
                            }
                            writtenRecords.add((byte[])arguments[0]);
                            return null;
                        }
                    }).when((Object)writer)).write((byte[])Mockito.any(byte[].class));
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
            return writer;
        }

        public Map<List<String>, List<byte[]>> getPartitionValuesToWrittenRecords() {
            return this.partitionValuesToWrittenRecords;
        }

        public List<byte[]> getRecordWritten(List<String> partitionValues) {
            return this.partitionValuesToWrittenRecords.get(partitionValues);
        }
    }
}

