/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.bolt.mapper;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StrictJsonWriter;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordHiveMapper
implements HiveMapper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRecordHiveMapper.class);
    private Fields columnFields;
    private Fields partitionFields;
    private String timeFormat;
    private SimpleDateFormat parseDate;

    public JsonRecordHiveMapper withColumnFields(Fields columnFields) {
        this.columnFields = columnFields;
        return this;
    }

    public JsonRecordHiveMapper withPartitionFields(Fields partitionFields) {
        this.partitionFields = partitionFields;
        return this;
    }

    public JsonRecordHiveMapper withTimeAsPartitionField(String timeFormat) {
        this.timeFormat = timeFormat;
        this.parseDate = new SimpleDateFormat(timeFormat);
        return this;
    }

    @Override
    public RecordWriter createRecordWriter(HiveEndPoint endPoint) throws StreamingException, IOException, ClassNotFoundException {
        return new StrictJsonWriter(endPoint);
    }

    @Override
    public void write(TransactionBatch txnBatch, Tuple tuple) throws StreamingException, IOException, InterruptedException {
        txnBatch.write(this.mapRecord(tuple));
    }

    @Override
    public List<String> mapPartitions(Tuple tuple) {
        ArrayList<String> partitionList = new ArrayList<String>();
        if (this.partitionFields != null) {
            for (String field : this.partitionFields) {
                partitionList.add(tuple.getStringByField(field));
            }
        }
        if (this.timeFormat != null) {
            partitionList.add(this.getPartitionsByTimeFormat());
        }
        return partitionList;
    }

    @Override
    public List<String> mapPartitions(TridentTuple tuple) {
        ArrayList<String> partitionList = new ArrayList<String>();
        if (this.partitionFields != null) {
            for (String field : this.partitionFields) {
                partitionList.add(tuple.getStringByField(field));
            }
        }
        if (this.timeFormat != null) {
            partitionList.add(this.getPartitionsByTimeFormat());
        }
        return partitionList;
    }

    @Override
    public byte[] mapRecord(Tuple tuple) {
        JSONObject obj = new JSONObject();
        if (this.columnFields != null) {
            for (String field : this.columnFields) {
                obj.put((Object)field, tuple.getValueByField(field));
            }
        }
        return obj.toJSONString().getBytes();
    }

    @Override
    public byte[] mapRecord(TridentTuple tuple) {
        JSONObject obj = new JSONObject();
        if (this.columnFields != null) {
            for (String field : this.columnFields) {
                obj.put((Object)field, tuple.getValueByField(field));
            }
        }
        return obj.toJSONString().getBytes();
    }

    private String getPartitionsByTimeFormat() {
        return this.parseDate.format(System.currentTimeMillis());
    }
}

