/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.bolt;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.StreamingConnection;
import org.apache.storm.Config;
import org.apache.storm.hive.bolt.HiveBolt;
import org.apache.storm.hive.bolt.HiveSetupUtil;
import org.apache.storm.hive.bolt.mapper.DelimitedRecordHiveMapper;
import org.apache.storm.hive.bolt.mapper.HiveMapper;
import org.apache.storm.hive.bolt.mapper.JsonRecordHiveMapper;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.MockTupleHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHiveBolt {
    static final String dbName = "testdb";
    static final String tblName = "test_table";
    static final String dbName1 = "testdb1";
    static final String tblName1 = "test_table1";
    static final String PART1_NAME = "city";
    static final String PART2_NAME = "state";
    static final String[] partNames = new String[]{"city", "state"};
    final String partitionVals = "sunnyvale,ca";
    private static final String COL1 = "id";
    private static final String COL2 = "msg";
    final String[] colNames = new String[]{"id", "msg"};
    final String[] colNames1 = new String[]{"msg", "id"};
    private String[] colTypes = new String[]{"int", "string"};
    private final HiveConf conf;
    private final Driver driver;
    private final int port;
    final String metaStoreURI;
    private String dbLocation;
    private Config config = new Config();
    private HiveBolt bolt;
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    @Rule
    public TemporaryFolder dbFolder = new TemporaryFolder();
    @Mock
    private OutputCollector collector;
    private static final Logger LOG = LoggerFactory.getLogger(HiveBolt.class);

    public TestHiveBolt() throws Exception {
        this.port = 9083;
        this.dbLocation = new String();
        this.metaStoreURI = null;
        this.conf = HiveSetupUtil.getHiveConf();
        TxnDbUtil.setConfValues((HiveConf)this.conf);
        TxnDbUtil.cleanDb();
        TxnDbUtil.prepDb();
        SessionState.start((SessionState)new CliSessionState(this.conf));
        this.driver = new Driver(this.conf);
    }

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        HiveSetupUtil.dropDB(this.conf, dbName);
        this.dbLocation = WINDOWS ? this.dbFolder.newFolder("testdb.db").getCanonicalPath() : "raw://" + this.dbFolder.newFolder("testdb.db").getCanonicalPath();
        HiveSetupUtil.createDbAndTable(this.conf, dbName, tblName, Arrays.asList("sunnyvale,ca".split(",")), this.colNames, this.colTypes, partNames, this.dbLocation);
        System.out.println("done");
    }

    @Test
    public void testEndpointConnection() throws Exception {
        HiveEndPoint endPt = new HiveEndPoint(this.metaStoreURI, dbName, tblName, Arrays.asList("sunnyvale,ca".split(",")));
        StreamingConnection connection = endPt.newConnection(false, null);
        connection.close();
        endPt = new HiveEndPoint(this.metaStoreURI, dbName, tblName, null);
        endPt.newConnection(false, null).close();
    }

    @Test
    public void testWithByteArrayIdandMessage() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        String city = "sunnyvale";
        String state = "ca";
        this.checkRecordCountInTable(tblName, dbName, 0);
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 4; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            this.bolt.execute(tuple);
            tupleSet.add(tuple);
        }
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        this.checkRecordCountInTable(tblName, dbName, 4);
        this.bolt.cleanup();
    }

    @Test
    public void testWithoutPartitions() throws Exception {
        HiveSetupUtil.dropDB(this.conf, dbName1);
        HiveSetupUtil.createDbAndTable(this.conf, dbName1, tblName1, null, this.colNames, this.colTypes, null, this.dbLocation);
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName1, tblName1, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2)).withAutoCreatePartitions(Boolean.valueOf(false));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        String city = "sunnyvale";
        String state = "ca";
        this.checkRecordCountInTable(tblName1, dbName1, 0);
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 4; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            this.bolt.execute(tuple);
            tupleSet.add(tuple);
        }
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        this.bolt.cleanup();
        this.checkRecordCountInTable(tblName1, dbName1, 4);
    }

    @Test
    public void testWithTimeformat() throws Exception {
        String[] partNames1 = new String[]{"dt"};
        String timeFormat = "yyyy/MM/dd";
        HiveSetupUtil.dropDB(this.conf, dbName1);
        HiveSetupUtil.createDbAndTable(this.conf, dbName1, tblName1, null, this.colNames, this.colTypes, partNames1, this.dbLocation);
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withTimeAsPartitionField(timeFormat);
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName1, tblName1, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1)).withMaxOpenConnections(Integer.valueOf(1));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Integer id = 100;
        String msg = "test-123";
        Date d = new Date();
        SimpleDateFormat parseDate = new SimpleDateFormat(timeFormat);
        String today = parseDate.format(d.getTime());
        this.checkRecordCountInTable(tblName1, dbName1, 0);
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 2; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, null, null);
            tupleSet.add(tuple);
            this.bolt.execute(tuple);
        }
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        this.checkDataWritten(tblName1, dbName1, "100,test-123," + today, "100,test-123," + today);
        this.bolt.cleanup();
    }

    @Test
    public void testData() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        this.bolt.execute(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        this.checkDataWritten(tblName, dbName, "1,SJC,Sunnyvale,CA");
        this.bolt.cleanup();
    }

    @Test
    public void testJsonWriter() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(1));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, this.collector);
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        this.bolt.execute(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        this.checkDataWritten(tblName, dbName, "1,SJC,Sunnyvale,CA");
        this.bolt.cleanup();
    }

    @Test
    public void testNoAcksUntilFlushed() {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        this.bolt.execute(tuple1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.collector});
        this.bolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple2);
        this.bolt.cleanup();
    }

    @Test
    public void testNoAcksIfFlushFails() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        HiveBolt spyBolt = (HiveBolt)Mockito.spy((Object)new HiveBolt(hiveOptions));
        ((HiveBolt)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)spyBolt)).flushAllWriters(true);
        spyBolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        spyBolt.execute(tuple1);
        spyBolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple1);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple2);
        spyBolt.cleanup();
    }

    @Test
    public void testTickTuple() {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple tuple1 = this.generateTestTuple(1, "SJC", "Sunnyvale", "CA");
        Tuple tuple2 = this.generateTestTuple(2, "SFO", "San Jose", "CA");
        this.bolt.execute(tuple1);
        Tuple mockTick = MockTupleHelpers.mockTickTuple();
        this.bolt.execute(mockTick);
        ((OutputCollector)Mockito.verify((Object)this.collector)).ack(tuple1);
        this.bolt.execute(tuple2);
        ((OutputCollector)Mockito.verify((Object)this.collector, (VerificationMode)Mockito.never())).ack(tuple2);
        this.bolt.cleanup();
    }

    @Test
    public void testNoTickEmptyBatches() throws Exception {
        JsonRecordHiveMapper mapper = new JsonRecordHiveMapper().withColumnFields(new Fields(this.colNames1)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(2)).withBatchSize(Integer.valueOf(2));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Tuple mockTick = MockTupleHelpers.mockTickTuple();
        this.bolt.execute(mockTick);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.collector});
        this.bolt.cleanup();
    }

    @Test
    public void testMultiPartitionTuples() throws Exception {
        DelimitedRecordHiveMapper mapper = new DelimitedRecordHiveMapper().withColumnFields(new Fields(this.colNames)).withPartitionFields(new Fields(partNames));
        HiveOptions hiveOptions = new HiveOptions(this.metaStoreURI, dbName, tblName, (HiveMapper)mapper).withTxnsPerBatch(Integer.valueOf(10)).withBatchSize(Integer.valueOf(10));
        this.bolt = new HiveBolt(hiveOptions);
        this.bolt.prepare((Map)this.config, null, new OutputCollector((IOutputCollector)this.collector));
        Integer id = 1;
        String msg = "test";
        String city = "San Jose";
        String state = "CA";
        this.checkRecordCountInTable(tblName, dbName, 0);
        HashSet<Tuple> tupleSet = new HashSet<Tuple>();
        for (int i = 0; i < 100; ++i) {
            Tuple tuple = this.generateTestTuple(id, msg, city, state);
            tupleSet.add(tuple);
            this.bolt.execute(tuple);
        }
        this.checkRecordCountInTable(tblName, dbName, 100);
        for (Tuple t : tupleSet) {
            ((OutputCollector)Mockito.verify((Object)this.collector)).ack(t);
        }
        this.bolt.cleanup();
    }

    private void checkRecordCountInTable(String tableName, String dbName, int expectedCount) throws CommandNeedRetryException, IOException {
        int count = this.listRecordsInTable(tableName, dbName).size();
        junit.framework.Assert.assertEquals((int)expectedCount, (int)count);
    }

    private ArrayList<String> listRecordsInTable(String tableName, String dbName) throws CommandNeedRetryException, IOException {
        this.driver.compile("select * from " + dbName + "." + tableName);
        ArrayList<String> res = new ArrayList<String>();
        this.driver.getResults(res);
        return res;
    }

    private void checkDataWritten(String tableName, String dbName, String ... row) throws CommandNeedRetryException, IOException {
        ArrayList<String> results = this.listRecordsInTable(tableName, dbName);
        for (int i = 0; i < row.length && results.size() > 0; ++i) {
            String resultRow = results.get(i).replace("\t", ",");
            System.out.println(resultRow);
            Assert.assertEquals((Object)row[i], (Object)resultRow);
        }
    }

    private Tuple generateTestTuple(Object id, Object msg, Object city, Object state) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{TestHiveBolt.COL1, TestHiveBolt.COL2, TestHiveBolt.PART1_NAME, TestHiveBolt.PART2_NAME});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{id, msg, city, state}), 1, "");
    }
}

