/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.trident;

import backtype.storm.task.IMetricsContext;
import backtype.storm.topology.FailedException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.storm.hive.common.HiveOptions;
import org.apache.storm.hive.common.HiveUtils;
import org.apache.storm.hive.common.HiveWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.state.State;
import storm.trident.tuple.TridentTuple;

public class HiveState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(HiveState.class);
    private HiveOptions options;
    private Integer currentBatchSize;
    private ExecutorService callTimeoutPool;
    private transient Timer heartBeatTimer;
    private AtomicBoolean timeToSendHeartBeat = new AtomicBoolean(false);
    private UserGroupInformation ugi = null;
    private Boolean kerberosEnabled = false;
    HashMap<HiveEndPoint, HiveWriter> allWriters;

    public HiveState(HiveOptions options) {
        this.options = options;
        this.currentBatchSize = 0;
    }

    public void beginCommit(Long txId) {
    }

    public void commit(Long txId) {
    }

    public void prepare(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
        try {
            if (this.options.getKerberosPrincipal() == null && this.options.getKerberosKeytab() == null) {
                this.kerberosEnabled = false;
            } else if (this.options.getKerberosPrincipal() != null && this.options.getKerberosKeytab() != null) {
                this.kerberosEnabled = true;
            } else {
                throw new IllegalArgumentException("To enable Kerberos, need to set both KerberosPrincipal  & KerberosKeytab");
            }
            if (this.kerberosEnabled.booleanValue()) {
                try {
                    this.ugi = HiveUtils.authenticate(this.options.getKerberosKeytab(), this.options.getKerberosPrincipal());
                }
                catch (HiveUtils.AuthenticationFailed ex) {
                    LOG.error("Hive kerberos authentication failed " + ex.getMessage(), (Throwable)ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            this.allWriters = new HashMap();
            String timeoutName = "hive-bolt-%d";
            this.callTimeoutPool = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat(timeoutName).build());
            this.heartBeatTimer = new Timer();
            this.setupHeartBeatTimer();
        }
        catch (Exception e) {
            LOG.warn("unable to make connection to hive ", (Throwable)e);
        }
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        try {
            this.writeTuples(tuples);
        }
        catch (Exception e) {
            this.abortAndCloseWriters();
            LOG.warn("hive streaming failed.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    private void writeTuples(List<TridentTuple> tuples) throws Exception {
        if (this.timeToSendHeartBeat.compareAndSet(true, false)) {
            this.enableHeartBeatOnAllWriters();
        }
        for (TridentTuple tuple : tuples) {
            List<String> partitionVals = this.options.getMapper().mapPartitions(tuple);
            HiveEndPoint endPoint = HiveUtils.makeEndPoint(partitionVals, this.options);
            HiveWriter writer = this.getOrCreateWriter(endPoint);
            writer.write(this.options.getMapper().mapRecord(tuple));
            Integer n = this.currentBatchSize;
            Integer n2 = this.currentBatchSize = Integer.valueOf(this.currentBatchSize + 1);
            if (this.currentBatchSize < this.options.getBatchSize()) continue;
            this.flushAllWriters();
            this.currentBatchSize = 0;
        }
    }

    private void abortAndCloseWriters() {
        try {
            this.abortAllWriters();
            this.closeAllWriters();
        }
        catch (InterruptedException e) {
            LOG.warn("unable to close hive connections. ", (Throwable)e);
        }
        catch (IOException ie) {
            LOG.warn("unable to close hive connections. ", (Throwable)ie);
        }
    }

    private void abortAllWriters() throws InterruptedException {
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : this.allWriters.entrySet()) {
            entry.getValue().abort();
        }
    }

    private void closeAllWriters() throws InterruptedException, IOException {
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : this.allWriters.entrySet()) {
            entry.getValue().close();
        }
        this.allWriters.clear();
    }

    private void setupHeartBeatTimer() {
        if (this.options.getHeartBeatInterval() > 0) {
            this.heartBeatTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    HiveState.this.timeToSendHeartBeat.set(true);
                    HiveState.this.setupHeartBeatTimer();
                }
            }, this.options.getHeartBeatInterval() * 1000);
        }
    }

    private void flushAllWriters() throws HiveWriter.CommitFailure, HiveWriter.TxnBatchFailure, HiveWriter.TxnFailure, InterruptedException {
        for (HiveWriter writer : this.allWriters.values()) {
            writer.flush(true);
        }
    }

    private void enableHeartBeatOnAllWriters() {
        for (HiveWriter writer : this.allWriters.values()) {
            writer.setHeartBeatNeeded();
        }
    }

    private HiveWriter getOrCreateWriter(HiveEndPoint endPoint) throws HiveWriter.ConnectFailure, InterruptedException {
        try {
            HiveWriter writer = this.allWriters.get(endPoint);
            if (writer == null) {
                int retired;
                LOG.info("Creating Writer to Hive end point : " + endPoint);
                writer = HiveUtils.makeHiveWriter(endPoint, this.callTimeoutPool, this.ugi, this.options);
                if (this.allWriters.size() > this.options.getMaxOpenConnections() && (retired = this.retireIdleWriters()) == 0) {
                    this.retireEldestWriter();
                }
                this.allWriters.put(endPoint, writer);
            }
            return writer;
        }
        catch (HiveWriter.ConnectFailure e) {
            LOG.error("Failed to create HiveWriter for endpoint: " + endPoint, (Throwable)e);
            throw e;
        }
    }

    private void retireEldestWriter() {
        long oldestTimeStamp = System.currentTimeMillis();
        HiveEndPoint eldest = null;
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : this.allWriters.entrySet()) {
            if (entry.getValue().getLastUsed() >= oldestTimeStamp) continue;
            eldest = entry.getKey();
            oldestTimeStamp = entry.getValue().getLastUsed();
        }
        try {
            LOG.info("Closing least used Writer to Hive end point : " + eldest);
            this.allWriters.remove(eldest).close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close writer for end point: " + eldest, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted when attempting to close writer for end point: " + eldest, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private int retireIdleWriters() {
        int count = 0;
        long now = System.currentTimeMillis();
        ArrayList<HiveEndPoint> retirees = new ArrayList<HiveEndPoint>();
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : this.allWriters.entrySet()) {
            if (now - entry.getValue().getLastUsed() <= (long)this.options.getIdleTimeout().intValue()) continue;
            ++count;
            retirees.add(entry.getKey());
        }
        for (HiveEndPoint ep : retirees) {
            try {
                LOG.info("Closing idle Writer to Hive end point : {}", (Object)ep);
                this.allWriters.remove(ep).close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close writer for end point: {}. Error: " + ep, (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted when attempting to close writer for end point: " + ep, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return count;
    }

    public void cleanup() {
        ExecutorService[] toShutdown;
        for (Map.Entry<HiveEndPoint, HiveWriter> entry : this.allWriters.entrySet()) {
            try {
                HiveWriter w = entry.getValue();
                LOG.info("Flushing writer to {}", (Object)w);
                w.flush(false);
                LOG.info("Closing writer to {}", (Object)w);
                w.close();
            }
            catch (Exception ex) {
                LOG.warn("Error while closing writer to " + entry.getKey() + ". Exception follows.", (Throwable)ex);
                if (!(ex instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
        }
        for (ExecutorService execService : toShutdown = new ExecutorService[]{this.callTimeoutPool}) {
            execService.shutdown();
            try {
                while (!execService.isTerminated()) {
                    execService.awaitTermination(this.options.getCallTimeOut().intValue(), TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("shutdown interrupted on " + execService, (Throwable)ex);
            }
        }
        this.callTimeoutPool = null;
    }
}

