/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class TaskId
implements Writeable<TaskId> {
    public static final TaskId EMPTY_TASK_ID = new TaskId("", -1L);
    private final String nodeId;
    private final long id;

    public TaskId(String nodeId, long id) {
        this.nodeId = nodeId;
        this.id = id;
    }

    public TaskId(String taskId) {
        if (Strings.hasLength(taskId) && !"unset".equals(taskId)) {
            String[] s2 = Strings.split(taskId, ":");
            if (s2 == null || s2.length != 2) {
                throw new IllegalArgumentException("malformed task id " + taskId);
            }
            this.nodeId = s2[0];
            try {
                this.id = Long.parseLong(s2[1]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("malformed task id " + taskId, ex);
            }
        } else {
            this.nodeId = "";
            this.id = -1L;
        }
    }

    public TaskId(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.id = in.readLong();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSet() {
        return this.id != -1L;
    }

    public String toString() {
        if (this.isSet()) {
            return this.nodeId + ":" + this.id;
        }
        return "unset";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeLong(this.id);
    }

    @Override
    public TaskId readFrom(StreamInput in) throws IOException {
        return new TaskId(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        if (this.id != taskId.id) {
            return false;
        }
        return this.nodeId.equals(taskId.nodeId);
    }

    public int hashCode() {
        int result = this.nodeId.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

