/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.serialdiff;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffParser;
import org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffPipelineAggregator;

public class SerialDiffBuilder
extends PipelineAggregatorBuilder<SerialDiffBuilder> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;
    private Integer lag;

    public SerialDiffBuilder(String name) {
        super(name, SerialDiffPipelineAggregator.TYPE.name());
    }

    public SerialDiffBuilder format(String format) {
        this.format = format;
        return this;
    }

    public SerialDiffBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return this;
    }

    public SerialDiffBuilder lag(Integer lag) {
        this.lag = lag;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(SerialDiffParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(SerialDiffParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.lag != null) {
            builder.field(SerialDiffParser.LAG.getPreferredName(), this.lag);
        }
        return builder;
    }
}

