/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class StatsAggregator
extends NumericMetricsAggregator.MultiValue {
    final ValuesSource.Numeric valuesSource;
    final ValueFormatter formatter;
    LongArray counts;
    DoubleArray sums;
    DoubleArray mins;
    DoubleArray maxes;

    public StatsAggregator(String name, ValuesSource.Numeric valuesSource, ValueFormatter formatter, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.mins = bigArrays.newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = bigArrays.newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = formatter;
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= StatsAggregator.this.counts.size()) {
                    long from = StatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    StatsAggregator.this.counts = bigArrays.resize(StatsAggregator.this.counts, overSize);
                    StatsAggregator.this.sums = bigArrays.resize(StatsAggregator.this.sums, overSize);
                    StatsAggregator.this.mins = bigArrays.resize(StatsAggregator.this.mins, overSize);
                    StatsAggregator.this.maxes = bigArrays.resize(StatsAggregator.this.maxes, overSize);
                    StatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    StatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                values.setDocument(doc);
                int valuesCount = values.count();
                StatsAggregator.this.counts.increment(bucket, valuesCount);
                double sum = 0.0;
                double min2 = StatsAggregator.this.mins.get(bucket);
                double max = StatsAggregator.this.maxes.get(bucket);
                for (int i = 0; i < valuesCount; ++i) {
                    double value = values.valueAt(i);
                    sum += value;
                    min2 = Math.min(min2, value);
                    max = Math.max(max, value);
                }
                StatsAggregator.this.sums.increment(bucket, sum);
                StatsAggregator.this.mins.set(bucket, min2);
                StatsAggregator.this.maxes.set(bucket, max);
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.counts.size()) {
            switch (InternalStats.Metrics.resolve(name)) {
                case count: {
                    return 0.0;
                }
                case sum: {
                    return 0.0;
                }
                case min: {
                    return Double.POSITIVE_INFINITY;
                }
                case max: {
                    return Double.NEGATIVE_INFINITY;
                }
                case avg: {
                    return Double.NaN;
                }
            }
            throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
        }
        switch (InternalStats.Metrics.resolve(name)) {
            case count: {
                return this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, InternalStats.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new StatsAggregator(this.name, null, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new StatsAggregator(this.name, valuesSource, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }
    }
}

