/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesParser;

public class PercentilesBuilder
extends AbstractPercentilesBuilder<PercentilesBuilder> {
    double[] percentiles;

    public PercentilesBuilder(String name) {
        super(name, "percentiles");
    }

    public PercentilesBuilder percentiles(double ... percentiles) {
        for (int i = 0; i < percentiles.length; ++i) {
            if (!(percentiles[i] < 0.0) && !(percentiles[i] > 100.0)) continue;
            throw new IllegalArgumentException("the percents in the percentiles aggregation [" + this.getName() + "] must be in the [0, 100] range");
        }
        this.percentiles = percentiles;
        return this;
    }

    @Override
    protected void doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.percentiles != null) {
            builder.field(PercentilesParser.PERCENTS_FIELD.getPreferredName(), this.percentiles);
        }
    }
}

