/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public abstract class ValuesSourceAggregationBuilder<B extends ValuesSourceAggregationBuilder<B>>
extends AggregationBuilder<B> {
    private Script script;
    private String field;
    @Deprecated
    private String scriptString;
    @Deprecated
    private String lang;
    @Deprecated
    private Map<String, Object> params;
    private Object missing;

    protected ValuesSourceAggregationBuilder(String name, String type) {
        super(name, type);
    }

    public B field(String field) {
        this.field = field;
        return (B)this;
    }

    public B script(Script script) {
        this.script = script;
        return (B)this;
    }

    public B missing(Object missingValue) {
        this.missing = missingValue;
        return (B)this;
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script == null) {
            if (this.scriptString != null) {
                builder.field("script", new Script(this.scriptString, ScriptService.ScriptType.INLINE, this.lang, this.params));
            }
        } else {
            builder.field("script", this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        this.doInternalXContent(builder, builderParams);
        return builder.endObject();
    }

    protected abstract XContentBuilder doInternalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

