/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.support;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.path.PathTrie;

public class RestUtils {
    public static final PathTrie.Decoder REST_DECODER = new PathTrie.Decoder(){

        @Override
        public String decode(String value) {
            return RestUtils.decodeComponent(value);
        }
    };

    public static void decodeQueryString(String s2, int fromIndex, Map<String, String> params) {
        int i;
        if (fromIndex < 0) {
            return;
        }
        if (fromIndex >= s2.length()) {
            return;
        }
        int queryStringLength = s2.contains("#") ? s2.indexOf("#") : s2.length();
        String name = null;
        int pos = fromIndex;
        char c = '\u0000';
        for (i = fromIndex; i < queryStringLength; ++i) {
            c = s2.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = RestUtils.decodeComponent(s2.substring(pos, i));
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (name == null && pos != i) {
                RestUtils.addParam(params, RestUtils.decodeComponent(s2.substring(pos, i)), "");
            } else if (name != null) {
                RestUtils.addParam(params, name, RestUtils.decodeComponent(s2.substring(pos, i)));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                RestUtils.addParam(params, RestUtils.decodeComponent(s2.substring(pos, i)), "");
            } else {
                RestUtils.addParam(params, name, RestUtils.decodeComponent(s2.substring(pos, i)));
            }
        } else if (name != null) {
            RestUtils.addParam(params, name, "");
        }
    }

    private static void addParam(Map<String, String> params, String name, String value) {
        params.put(name, value);
    }

    public static String decodeComponent(String s2) {
        return RestUtils.decodeComponent(s2, Charsets.UTF_8);
    }

    public static String decodeComponent(String s2, Charset charset) {
        if (s2 == null) {
            return "";
        }
        int size = s2.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '%': {
                    ++i;
                }
                case '+': {
                    modified = true;
                }
            }
        }
        if (!modified) {
            return s2;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        block9: for (int i = 0; i < size; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '+': {
                    buf[pos++] = 32;
                    continue block9;
                }
                case '%': {
                    if (i == size - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s2);
                    }
                    if ((c = s2.charAt(++i)) == '%') {
                        buf[pos++] = 37;
                        continue block9;
                    }
                    if (i == size - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s2);
                    }
                    c = RestUtils.decodeHexNibble(c);
                    char c2 = RestUtils.decodeHexNibble(s2.charAt(++i));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s2.charAt(i - 1) + s2.charAt(i) + "' at index " + (i - 2) + " of: " + s2);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos++] = (byte)c;
                }
            }
        }
        return new String(buf, 0, pos, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }

    public static Pattern checkCorsSettingForRegex(String corsSetting) {
        boolean isRegex;
        if (corsSetting == null) {
            return null;
        }
        int len = corsSetting.length();
        boolean bl = isRegex = len > 2 && corsSetting.startsWith("/") && corsSetting.endsWith("/");
        if (isRegex) {
            return Pattern.compile(corsSetting.substring(1, corsSetting.length() - 1));
        }
        return null;
    }

    public static String[] corsSettingAsArray(String corsSetting) {
        if (Strings.isNullOrEmpty(corsSetting)) {
            return new String[0];
        }
        String[] arr = corsSetting.split(",");
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i].trim();
        }
        return arr;
    }
}

