/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

public class InMemoryGeoBoundingBoxQuery
extends Query {
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;
    private final IndexGeoPointFieldData indexFieldData;

    public InMemoryGeoBoundingBoxQuery(GeoPoint topLeft, GeoPoint bottomRight, IndexGeoPointFieldData indexFieldData) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                int maxDoc = context.reader().maxDoc();
                MultiGeoPointValues values = ((AtomicGeoPointFieldData)InMemoryGeoBoundingBoxQuery.this.indexFieldData.load(context)).getGeoPointValues();
                if (InMemoryGeoBoundingBoxQuery.this.topLeft.lon() > InMemoryGeoBoundingBoxQuery.this.bottomRight.lon()) {
                    return new Meridian180GeoBoundingBoxBits(maxDoc, values, InMemoryGeoBoundingBoxQuery.this.topLeft, InMemoryGeoBoundingBoxQuery.this.bottomRight);
                }
                return new GeoBoundingBoxBits(maxDoc, values, InMemoryGeoBoundingBoxQuery.this.topLeft, InMemoryGeoBoundingBoxQuery.this.bottomRight);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "GeoBoundingBoxFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + this.topLeft + ", " + this.bottomRight + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        InMemoryGeoBoundingBoxQuery other = (InMemoryGeoBoundingBoxQuery)obj;
        return this.fieldName().equalsIgnoreCase(other.fieldName()) && this.topLeft.equals(other.topLeft) && this.bottomRight.equals(other.bottomRight);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        h2 = 31 * h2 + this.fieldName().hashCode();
        h2 = 31 * h2 + this.topLeft.hashCode();
        h2 = 31 * h2 + this.bottomRight.hashCode();
        return h2;
    }

    private static class GeoBoundingBoxBits
    implements Bits {
        private final int maxDoc;
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public GeoBoundingBoxBits(int maxDoc, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            this.maxDoc = maxDoc;
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean get(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) || !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }

    private static class Meridian180GeoBoundingBoxBits
    implements Bits {
        private final int maxDoc;
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public Meridian180GeoBoundingBoxBits(int maxDoc, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            this.maxDoc = maxDoc;
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean get(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) && !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }
}

