/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.SuppressForbidden;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.internal.SearchContext;

@Deprecated
@SuppressForbidden(reason="Old p/c queries still use filters")
final class ParentIdsFilter
extends Filter {
    private final BytesRef parentTypeBr;
    private final BitSetProducer nonNestedDocsFilter;
    private final BytesRefHash parentIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Filter createShortCircuitFilter(BitSetProducer nonNestedDocsFilter, SearchContext searchContext, String parentType, SortedDocValues globalValues, LongBitSet parentOrds, long numFoundParents) {
        BytesRefHash parentIds;
        block4: {
            parentIds = null;
            boolean constructed = false;
            try {
                parentIds = new BytesRefHash(numFoundParents, searchContext.bigArrays());
                long parentOrd = parentOrds.nextSetBit(0L);
                while (parentOrd != -1L) {
                    parentIds.add(globalValues.lookupOrd((int)parentOrd));
                    parentOrd = parentOrds.nextSetBit(parentOrd + 1L);
                }
                constructed = true;
                if (constructed) break block4;
            }
            catch (Throwable throwable) {
                if (!constructed) {
                    Releasables.close(parentIds);
                }
                throw throwable;
            }
            Releasables.close(parentIds);
        }
        searchContext.addReleasable(parentIds, SearchContext.Lifetime.COLLECTION);
        return new ParentIdsFilter(parentType, nonNestedDocsFilter, parentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Filter createShortCircuitFilter(BitSetProducer nonNestedDocsFilter, SearchContext searchContext, String parentType, SortedDocValues globalValues, LongHash parentIdxs, long numFoundParents) {
        BytesRefHash parentIds;
        block4: {
            parentIds = null;
            boolean constructed = false;
            try {
                parentIds = new BytesRefHash(numFoundParents, searchContext.bigArrays());
                int id = 0;
                while ((long)id < parentIdxs.size()) {
                    parentIds.add(globalValues.lookupOrd((int)parentIdxs.get(id)));
                    ++id;
                }
                constructed = true;
                if (constructed) break block4;
            }
            catch (Throwable throwable) {
                if (!constructed) {
                    Releasables.close(parentIds);
                }
                throw throwable;
            }
            Releasables.close(parentIds);
        }
        searchContext.addReleasable(parentIds, SearchContext.Lifetime.COLLECTION);
        return new ParentIdsFilter(parentType, nonNestedDocsFilter, parentIds);
    }

    private ParentIdsFilter(String parentType, BitSetProducer nonNestedDocsFilter, BytesRefHash parentIds) {
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.parentTypeBr = new BytesRef(parentType);
        this.parentIds = parentIds;
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms("_uid");
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator();
        BytesRefBuilder uidSpare = new BytesRefBuilder();
        BytesRef idSpare = new BytesRef();
        if (acceptDocs == null) {
            acceptDocs = context.reader().getLiveDocs();
        }
        BitSet nonNestedDocs = null;
        if (this.nonNestedDocsFilter != null) {
            nonNestedDocs = this.nonNestedDocsFilter.getBitSet(context);
        }
        PostingsEnum docsEnum = null;
        BitSet result = null;
        int size = (int)this.parentIds.size();
        for (int i = 0; i < size; ++i) {
            this.parentIds.get(i, idSpare);
            BytesRef uid = Uid.createUidAsBytes(this.parentTypeBr, idSpare, uidSpare);
            if (!termsEnum.seekExact(uid)) continue;
            docsEnum = termsEnum.postings(docsEnum, 0);
            int docId = docsEnum.nextDoc();
            while (docId != Integer.MAX_VALUE && acceptDocs != null && !acceptDocs.get(docId)) {
                docId = docsEnum.nextDoc();
            }
            if (docId == Integer.MAX_VALUE) continue;
            if (result == null) {
                int expectedCardinality = size / (i + 1);
                result = expectedCardinality >= context.reader().maxDoc() >>> 10 ? new FixedBitSet(context.reader().maxDoc()) : new SparseFixedBitSet(context.reader().maxDoc());
            }
            if (nonNestedDocs != null) {
                docId = nonNestedDocs.nextSetBit(docId);
            }
            result.set(docId);
            assert (docsEnum.advance(docId + 1) == Integer.MAX_VALUE) : "DocId " + docId + " should have been the last one but docId " + docsEnum.docID() + " exists.";
        }
        return result == null ? null : new BitDocIdSet(result);
    }

    @Override
    public String toString(String field) {
        return "parentsFilter(type=" + this.parentTypeBr.utf8ToString() + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ParentIdsFilter other = (ParentIdsFilter)obj;
        return this.parentTypeBr.equals(other.parentTypeBr) && this.parentIds.equals(other.parentIds) && this.nonNestedDocsFilter.equals(this.nonNestedDocsFilter);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        h2 = 31 * h2 + this.parentTypeBr.hashCode();
        h2 = 31 * h2 + this.parentIds.hashCode();
        h2 = 31 * h2 + this.nonNestedDocsFilter.hashCode();
        return h2;
    }
}

