/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import org.elasticsearch.common.Strings;

public enum RegexpFlag {
    INTERSECTION(1),
    COMPLEMENT(2),
    EMPTY(4),
    ANYSTRING(8),
    INTERVAL(32),
    NONE(0),
    ALL(65535);

    final int value;

    private RegexpFlag(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    static int resolveValue(String flags) {
        if (flags == null || flags.isEmpty()) {
            return 65535;
        }
        int magic = 0;
        for (String s2 : Strings.delimitedListToStringArray(flags, "|")) {
            if (s2.isEmpty()) continue;
            try {
                RegexpFlag flag = RegexpFlag.valueOf(s2.toUpperCase(Locale.ROOT));
                if (flag == NONE) continue;
                if (flag == ALL) {
                    return flag.value();
                }
                magic |= flag.value();
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown regexp flag [" + s2 + "]");
            }
        }
        return magic;
    }
}

