/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public interface IndexFieldData<FD extends AtomicFieldData>
extends IndexComponent {
    public MappedFieldType.Names getFieldNames();

    public FieldDataType getFieldDataType();

    public FD load(LeafReaderContext var1);

    public FD loadDirect(LeafReaderContext var1) throws Exception;

    public XFieldComparatorSource comparatorSource(@Nullable Object var1, MultiValueMode var2, XFieldComparatorSource.Nested var3);

    public void clear();

    public static interface Global<FD extends AtomicFieldData>
    extends IndexFieldData<FD> {
        public IndexFieldData<FD> loadGlobal(DirectoryReader var1);

        public IndexFieldData<FD> localGlobalDirect(DirectoryReader var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData<?> build(Index var1, Settings var2, MappedFieldType var3, IndexFieldDataCache var4, CircuitBreakerService var5, MapperService var6);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        protected final boolean sortMissingFirst(Object missingValue) {
            return "_first".equals(missingValue);
        }

        protected final boolean sortMissingLast(Object missingValue) {
            return missingValue == null || "_last".equals(missingValue);
        }

        protected final Object missingObject(Object missingValue, boolean reversed) {
            if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
                boolean min2 = this.sortMissingFirst(missingValue) ^ reversed;
                switch (this.reducedType()) {
                    case INT: {
                        return min2 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    }
                    case LONG: {
                        return min2 ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                    case FLOAT: {
                        return Float.valueOf(min2 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    }
                    case DOUBLE: {
                        return min2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    case STRING: 
                    case STRING_VAL: {
                        return null;
                    }
                }
                throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
            }
            switch (this.reducedType()) {
                case INT: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).intValue();
                    }
                    return Integer.parseInt(missingValue.toString());
                }
                case LONG: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).longValue();
                    }
                    return Long.parseLong(missingValue.toString());
                }
                case FLOAT: {
                    if (missingValue instanceof Number) {
                        return Float.valueOf(((Number)missingValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(missingValue.toString()));
                }
                case DOUBLE: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).doubleValue();
                    }
                    return Double.parseDouble(missingValue.toString());
                }
                case STRING: 
                case STRING_VAL: {
                    if (missingValue instanceof BytesRef) {
                        return (BytesRef)missingValue;
                    }
                    if (missingValue instanceof byte[]) {
                        return new BytesRef((byte[])missingValue);
                    }
                    return new BytesRef(missingValue.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
        }

        public abstract SortField.Type reducedType();

        public Object missingValue(boolean reversed) {
            return null;
        }

        public static class Nested {
            private final BitSetProducer rootFilter;
            private final Weight innerFilter;

            public Nested(BitSetProducer rootFilter, Weight innerFilter) {
                this.rootFilter = rootFilter;
                this.innerFilter = innerFilter;
            }

            public BitSet rootDocs(LeafReaderContext ctx) throws IOException {
                return this.rootFilter.getBitSet(ctx);
            }

            public DocIdSetIterator innerDocs(LeafReaderContext ctx) throws IOException {
                Scorer s2 = this.innerFilter.scorer(ctx);
                return s2 == null ? null : s2.iterator();
            }
        }
    }

    public static class CommonSettings {
        public static final String SETTING_MEMORY_STORAGE_HINT = "memory_storage_hint";

        public static MemoryStorageFormat getMemoryStorageHint(FieldDataType fieldDataType) {
            String s2 = fieldDataType.getSettings().get("ordinals");
            if (s2 != null) {
                return "always".equals(s2) ? MemoryStorageFormat.ORDINALS : null;
            }
            return MemoryStorageFormat.fromString(fieldDataType.getSettings().get(SETTING_MEMORY_STORAGE_HINT));
        }

        public static enum MemoryStorageFormat {
            ORDINALS,
            PACKED,
            PAGED;


            public static MemoryStorageFormat fromString(String string) {
                for (MemoryStorageFormat e : MemoryStorageFormat.values()) {
                    if (!e.name().equalsIgnoreCase(string)) continue;
                    return e;
                }
                return null;
            }
        }
    }
}

