/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.Lucene47WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettingsService;

public class WordDelimiterTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final byte[] charTypeTable;
    private final int flags;
    private final CharArraySet protoWords;
    private static Pattern typePattern = Pattern.compile("(.*)\\s*=>\\s*(.*)\\s*$");
    char[] out = new char[256];

    @Inject
    public WordDelimiterTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        List<String> charTypeTableValues = Analysis.getWordList(env, settings, "type_table");
        this.charTypeTable = charTypeTableValues == null ? WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE : this.parseTypes(charTypeTableValues);
        int flags = 0;
        flags |= this.getFlag(1, settings, "generate_word_parts", true);
        flags |= this.getFlag(2, settings, "generate_number_parts", true);
        flags |= this.getFlag(4, settings, "catenate_words", false);
        flags |= this.getFlag(8, settings, "catenate_numbers", false);
        flags |= this.getFlag(16, settings, "catenate_all", false);
        flags |= this.getFlag(64, settings, "split_on_case_change", true);
        flags |= this.getFlag(32, settings, "preserve_original", false);
        flags |= this.getFlag(128, settings, "split_on_numerics", true);
        CharArraySet protectedWords = Analysis.getWordSet(env, settings, "protected_words");
        this.protoWords = protectedWords == null ? null : CharArraySet.copy(protectedWords);
        this.flags = flags |= this.getFlag(256, settings, "stem_english_possessive", true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_4_8)) {
            return new WordDelimiterFilter(tokenStream, this.charTypeTable, this.flags, this.protoWords);
        }
        return new Lucene47WordDelimiterFilter(tokenStream, this.charTypeTable, this.flags, this.protoWords);
    }

    public int getFlag(int flag, Settings settings, String key, boolean defaultValue) {
        if (settings.getAsBoolean(key, (Boolean)defaultValue).booleanValue()) {
            return flag;
        }
        return 0;
    }

    private byte[] parseTypes(Collection<String> rules) {
        TreeMap<Character, Byte> typeMap = new TreeMap<Character, Byte>();
        for (String rule : rules) {
            Matcher m3 = typePattern.matcher(rule);
            if (!m3.find()) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]");
            }
            String lhs = this.parseString(m3.group(1).trim());
            Byte rhs = this.parseType(m3.group(2).trim());
            if (lhs.length() != 1) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Only a single character is allowed.");
            }
            if (rhs == null) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Illegal type.");
            }
            typeMap.put(Character.valueOf(lhs.charAt(0)), rhs);
        }
        byte[] types = new byte[Math.max(((Character)typeMap.lastKey()).charValue() + '\u0001', WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE.length)];
        for (int i = 0; i < types.length; ++i) {
            types[i] = WordDelimiterIterator.getType(i);
        }
        for (Map.Entry mapping : typeMap.entrySet()) {
            types[((Character)mapping.getKey()).charValue()] = (Byte)mapping.getValue();
        }
        return types;
    }

    private Byte parseType(String s2) {
        if (s2.equals("LOWER")) {
            return (byte)1;
        }
        if (s2.equals("UPPER")) {
            return (byte)2;
        }
        if (s2.equals("ALPHA")) {
            return (byte)3;
        }
        if (s2.equals("DIGIT")) {
            return (byte)4;
        }
        if (s2.equals("ALPHANUM")) {
            return (byte)7;
        }
        if (s2.equals("SUBWORD_DELIM")) {
            return (byte)8;
        }
        return null;
    }

    private String parseString(String s2) {
        int readPos = 0;
        int len = s2.length();
        int writePos = 0;
        while (readPos < len) {
            int c;
            if ((c = s2.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new RuntimeException("Invalid escaped char in [" + s2 + "]");
                }
                c = s2.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new RuntimeException("Invalid escaped char in [" + s2 + "]");
                        }
                        c = (char)Integer.parseInt(s2.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            this.out[writePos++] = c;
        }
        return new String(this.out, 0, writePos);
    }
}

