/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public abstract class AsyncShardFetch<T extends BaseNodeResponse>
implements Releasable {
    protected final ESLogger logger;
    protected final String type;
    private final ShardId shardId;
    private final List<BaseNodesResponse<T>, T> action;
    private final Map<String, NodeEntry<T>> cache = new HashMap<String, NodeEntry<T>>();
    private final Set<String> nodesToIgnore = new HashSet<String>();
    private boolean closed;

    protected AsyncShardFetch(ESLogger logger, String type, ShardId shardId, List<? extends BaseNodesResponse<T>, T> action) {
        this.logger = logger;
        this.type = type;
        this.shardId = shardId;
        this.action = action;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    public synchronized int getNumberOfInFlightFetches() {
        int count = 0;
        for (NodeEntry<T> nodeEntry : this.cache.values()) {
            if (!nodeEntry.isFetching()) continue;
            ++count;
        }
        return count;
    }

    public synchronized FetchResult<T> fetchData(DiscoveryNodes nodes, MetaData metaData, Set<String> ignoreNodes) {
        if (this.closed) {
            throw new IllegalStateException(this.shardId + ": can't fetch data on closed async fetch");
        }
        this.nodesToIgnore.addAll(ignoreNodes);
        this.fillShardCacheWithDataNodes(this.cache, nodes);
        Set<NodeEntry<T>> nodesToFetch = this.findNodesToFetch(this.cache);
        if (!nodesToFetch.isEmpty()) {
            for (NodeEntry<T> nodeEntry : nodesToFetch) {
                nodeEntry.markAsFetching();
            }
            String[] nodesIds = new String[nodesToFetch.size()];
            int index = 0;
            for (NodeEntry<T> nodeEntry : nodesToFetch) {
                nodesIds[index++] = nodeEntry.getNodeId();
            }
            this.asyncFetch(this.shardId, nodesIds, metaData);
        }
        if (this.hasAnyNodeFetching(this.cache)) {
            return new FetchResult(this.shardId, null, ImmutableSet.of(), ImmutableSet.of());
        }
        HashMap<DiscoveryNode, T> fetchData = new HashMap<DiscoveryNode, T>();
        HashSet<String> failedNodes = new HashSet<String>();
        Iterator<Map.Entry<String, NodeEntry<T>>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, NodeEntry<T>> entry = it.next();
            String nodeId = entry.getKey();
            NodeEntry<T> nodeEntry = entry.getValue();
            DiscoveryNode node = nodes.get(nodeId);
            if (node == null) continue;
            if (nodeEntry.isFailed()) {
                it.remove();
                failedNodes.add(nodeEntry.getNodeId());
                continue;
            }
            if (nodeEntry.getValue() == null) continue;
            fetchData.put(node, nodeEntry.getValue());
        }
        ImmutableSet<String> allIgnoreNodes = ImmutableSet.copyOf(this.nodesToIgnore);
        this.nodesToIgnore.clear();
        if (!failedNodes.isEmpty() || !allIgnoreNodes.isEmpty()) {
            this.reroute(this.shardId, "nodes failed [" + failedNodes.size() + "], ignored [" + allIgnoreNodes.size() + "]");
        }
        return new FetchResult(this.shardId, fetchData, failedNodes, allIgnoreNodes);
    }

    protected synchronized void processAsyncFetch(ShardId shardId, T[] responses, FailedNodeException[] failures) {
        NodeEntry<T> nodeEntry;
        if (this.closed) {
            this.logger.trace("{} ignoring fetched [{}] results, already closed", shardId, this.type);
            return;
        }
        this.logger.trace("{} processing fetched [{}] results", shardId, this.type);
        if (responses != null) {
            for (T t : responses) {
                nodeEntry = this.cache.get(((BaseNodeResponse)t).getNode().getId());
                if (nodeEntry == null) continue;
                if (nodeEntry.isFailed()) {
                    this.logger.trace("{} node {} has failed for [{}] (failure [{}])", shardId, nodeEntry.getNodeId(), this.type, nodeEntry.getFailure());
                    continue;
                }
                this.logger.trace("{} marking {} as done for [{}]", shardId, nodeEntry.getNodeId(), this.type);
                nodeEntry.doneFetching(t);
            }
        }
        if (failures != null) {
            for (FailedNodeException failedNodeException : failures) {
                this.logger.trace("{} processing failure {} for [{}]", shardId, failedNodeException, this.type);
                nodeEntry = this.cache.get(failedNodeException.nodeId());
                if (nodeEntry == null || nodeEntry.isFailed()) continue;
                Throwable unwrappedCause = ExceptionsHelper.unwrapCause(failedNodeException.getCause());
                if (unwrappedCause instanceof EsRejectedExecutionException || unwrappedCause instanceof ReceiveTimeoutTransportException || unwrappedCause instanceof ElasticsearchTimeoutException) {
                    nodeEntry.restartFetching();
                    continue;
                }
                this.logger.warn("{}: failed to list shard for {} on node [{}]", failedNodeException, shardId, this.type, failedNodeException.nodeId());
                nodeEntry.doneFetching(failedNodeException.getCause());
            }
        }
        this.reroute(shardId, "post_response");
    }

    protected abstract void reroute(ShardId var1, String var2);

    private void fillShardCacheWithDataNodes(Map<String, NodeEntry<T>> shardCache, DiscoveryNodes nodes) {
        for (ObjectObjectCursor<String, DiscoveryNode> objectObjectCursor : nodes.dataNodes()) {
            DiscoveryNode node = (DiscoveryNode)objectObjectCursor.value;
            if (shardCache.containsKey(node.getId())) continue;
            shardCache.put(node.getId(), new NodeEntry(node.getId()));
        }
        Iterator<String> it = shardCache.keySet().iterator();
        while (it.hasNext()) {
            String string = it.next();
            if (nodes.nodeExists(string)) continue;
            it.remove();
        }
    }

    private Set<NodeEntry<T>> findNodesToFetch(Map<String, NodeEntry<T>> shardCache) {
        HashSet<NodeEntry<T>> nodesToFetch = new HashSet<NodeEntry<T>>();
        for (NodeEntry<T> nodeEntry : shardCache.values()) {
            if (nodeEntry.hasData() || nodeEntry.isFetching()) continue;
            nodesToFetch.add(nodeEntry);
        }
        return nodesToFetch;
    }

    private boolean hasAnyNodeFetching(Map<String, NodeEntry<T>> shardCache) {
        for (NodeEntry<T> nodeEntry : shardCache.values()) {
            if (!nodeEntry.isFetching()) continue;
            return true;
        }
        return false;
    }

    void asyncFetch(final ShardId shardId, final String[] nodesIds, MetaData metaData) {
        IndexMetaData indexMetaData = metaData.index(shardId.getIndex());
        this.logger.trace("{} fetching [{}] from {}", shardId, this.type, nodesIds);
        this.action.list(shardId, indexMetaData, nodesIds, new ActionListener<BaseNodesResponse<T>>(){

            @Override
            public void onResponse(BaseNodesResponse<T> response) {
                AsyncShardFetch.this.processAsyncFetch(shardId, response.getNodes(), response.failures());
            }

            @Override
            public void onFailure(Throwable e) {
                FailedNodeException[] failures = new FailedNodeException[nodesIds.length];
                for (int i = 0; i < failures.length; ++i) {
                    failures[i] = new FailedNodeException(nodesIds[i], "total failure in fetching", e);
                }
                AsyncShardFetch.this.processAsyncFetch(shardId, null, failures);
            }
        });
    }

    static class NodeEntry<T> {
        private final String nodeId;
        private boolean fetching;
        @Nullable
        private T value;
        private boolean valueSet;
        private Throwable failure;

        public NodeEntry(String nodeId) {
            this.nodeId = nodeId;
        }

        String getNodeId() {
            return this.nodeId;
        }

        boolean isFetching() {
            return this.fetching;
        }

        void markAsFetching() {
            assert (!this.fetching) : "double marking a node as fetching";
            this.fetching = true;
        }

        void doneFetching(T value) {
            assert (this.fetching) : "setting value but not in fetching mode";
            assert (this.failure == null) : "setting value when failure already set";
            this.valueSet = true;
            this.value = value;
            this.fetching = false;
        }

        void doneFetching(Throwable failure) {
            assert (this.fetching) : "setting value but not in fetching mode";
            assert (!this.valueSet) : "setting failure when already set value";
            assert (failure != null) : "setting failure can't be null";
            this.failure = failure;
            this.fetching = false;
        }

        void restartFetching() {
            assert (this.fetching) : "restarting fetching, but not in fetching mode";
            assert (!this.valueSet) : "value can't be set when restarting fetching";
            assert (this.failure == null) : "failure can't be set when restarting fetching";
            this.fetching = false;
        }

        boolean isFailed() {
            return this.failure != null;
        }

        boolean hasData() {
            return this.valueSet || this.failure != null;
        }

        Throwable getFailure() {
            assert (this.hasData()) : "getting failure when data has not been fetched";
            return this.failure;
        }

        @Nullable
        T getValue() {
            assert (this.failure == null) : "trying to fetch value, but its marked as failed, check isFailed";
            assert (this.valueSet) : "value is not set, hasn't been fetched yet";
            return this.value;
        }
    }

    public static class FetchResult<T extends BaseNodeResponse> {
        private final ShardId shardId;
        private final Map<DiscoveryNode, T> data;
        private final Set<String> failedNodes;
        private final Set<String> ignoreNodes;

        public FetchResult(ShardId shardId, Map<DiscoveryNode, T> data, Set<String> failedNodes, Set<String> ignoreNodes) {
            this.shardId = shardId;
            this.data = data;
            this.failedNodes = failedNodes;
            this.ignoreNodes = ignoreNodes;
        }

        public boolean hasData() {
            return this.data != null;
        }

        public Map<DiscoveryNode, T> getData() {
            assert (this.data != null) : "getData should only be called if there is data to be fetched, please check hasData first";
            return this.data;
        }

        public void processAllocation(RoutingAllocation allocation) {
            for (String ignoreNode : this.ignoreNodes) {
                allocation.addIgnoreShardForNode(this.shardId, ignoreNode);
            }
        }
    }

    public static interface List<NodesResponse extends BaseNodesResponse<NodeResponse>, NodeResponse extends BaseNodeResponse> {
        public void list(ShardId var1, IndexMetaData var2, String[] var3, ActionListener<NodesResponse> var4);
    }
}

