/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.property.PropertyPlaceholder;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoaderFactory;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class Settings
implements ToXContent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(Settings.class));
    public static final Settings EMPTY = new Builder().build();
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.*)\\.\\d+$");
    public static final String SETTINGS_REQUIRE_UNITS = "settings_require_units";
    private static boolean settingsRequireUnits = true;
    private ImmutableMap<String, String> settings;
    private final ImmutableMap<String, String> forcedUnderscoreSettings;

    public static void setSettingsRequireUnits(boolean v) {
        settingsRequireUnits = v;
    }

    public static boolean getSettingsRequireUnits() {
        return settingsRequireUnits;
    }

    Settings(Map<String, String> settings) {
        this.settings = ImmutableSortedMap.copyOf(settings);
        HashMap<String, String> forcedUnderscoreSettings = null;
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String toUnderscoreCase = Strings.toUnderscoreCase(entry.getKey());
            if (toUnderscoreCase.equals(entry.getKey())) continue;
            if (forcedUnderscoreSettings == null) {
                forcedUnderscoreSettings = new HashMap<String, String>();
            }
            forcedUnderscoreSettings.put(toUnderscoreCase, entry.getValue());
        }
        this.forcedUnderscoreSettings = forcedUnderscoreSettings == null ? ImmutableMap.of() : ImmutableMap.copyOf(forcedUnderscoreSettings);
    }

    public Map<String, String> getAsMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Map<String, Object> getAsStructuredMap() {
        HashMap<String, Object> map = Maps.newHashMapWithExpectedSize(2);
        for (Map.Entry entry : this.settings.entrySet()) {
            this.processSetting(map, "", (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        return map;
    }

    private void processSetting(Map<String, Object> map, String prefix, String setting, String value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = Maps.newHashMapWithExpectedSize(2);
                this.processSetting(newMap, "", rest, value);
                map.put(key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                this.processSetting(innerMap, "", rest, value);
                map.put(key, innerMap);
            } else {
                this.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    private Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    public Settings getByPrefix(String prefix) {
        Builder builder = new Builder();
        for (Map.Entry<String, String> entry : this.getAsMap().entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() < prefix.length()) continue;
            builder.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return builder.build();
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public String get(String setting) {
        String retVal = this.settings.get(setting);
        if (retVal != null) {
            return retVal;
        }
        return this.forcedUnderscoreSettings.get(setting);
    }

    public String get(String[] settings) {
        for (String setting : settings) {
            String retVal = this.get(setting);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    public String get(String[] settings, String defaultValue) {
        String retVal = this.get(settings);
        return retVal == null ? defaultValue : retVal;
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Float getAsFloat(String[] settings, Float defaultValue) throws SettingsException {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String[] settings, Double defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String[] settings, Integer defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String[] settings, Long defaultValue) {
        String sValue = this.get(settings);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + Arrays.toString(settings) + "] with value [" + sValue + "]", e);
        }
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(setting), defaultValue);
    }

    public Boolean getAsBoolean(String[] settings, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(settings), defaultValue);
    }

    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(setting), defaultValue, setting);
    }

    public TimeValue getAsTime(String[] settings, TimeValue defaultValue) {
        for (String setting : settings) {
            String retVal = this.get(setting);
            if (retVal == null) continue;
            TimeValue.parseTimeValue(this.get(settings), defaultValue, setting);
        }
        return defaultValue;
    }

    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsBytesSize(String[] settings, ByteSizeValue defaultValue) throws SettingsException {
        for (String setting : settings) {
            String retVal = this.get(setting);
            if (retVal == null) continue;
            ByteSizeValue.parseBytesSizeValue(this.get(settings), defaultValue, setting);
        }
        return defaultValue;
    }

    public ByteSizeValue getAsMemory(String setting, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(setting, defaultValue), setting);
    }

    public ByteSizeValue getAsMemory(String[] settings, String defaultValue) throws SettingsException {
        for (String setting : settings) {
            String retVal = this.get(setting);
            if (retVal == null) continue;
            return MemorySizeValue.parseBytesSizeValueOrHeapRatio(retVal, setting);
        }
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(defaultValue, settings[0]);
    }

    public RatioValue getAsRatio(String setting, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(setting, defaultValue));
    }

    public RatioValue getAsRatio(String[] settings, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(settings, defaultValue));
    }

    public SizeValue getAsSize(String setting, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(setting), defaultValue);
    }

    public SizeValue getAsSize(String[] settings, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(settings), defaultValue);
    }

    public String[] getAsArray(String settingPrefix) throws SettingsException {
        return this.getAsArray(settingPrefix, Strings.EMPTY_ARRAY, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray) throws SettingsException {
        return this.getAsArray(settingPrefix, defaultArray, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray, Boolean commaDelimited) throws SettingsException {
        String value;
        ArrayList<String> result = new ArrayList<String>();
        if (this.get(settingPrefix) != null) {
            if (commaDelimited.booleanValue()) {
                String[] strings = Strings.splitStringByCommaToArray(this.get(settingPrefix));
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(settingPrefix).trim());
            }
        }
        int counter = 0;
        while ((value = this.get(settingPrefix + '.' + counter++)) != null) {
            result.add(value.trim());
        }
        if (result.isEmpty()) {
            return defaultArray;
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength(settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + settingPrefix);
        }
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> map = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Object o : this.settings.keySet()) {
            String setting = (String)o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            LinkedHashMap<String, String> groupSettings = (LinkedHashMap<String, String>)map.get(name);
            if (groupSettings == null) {
                groupSettings = new LinkedHashMap<String, String>();
                map.put(name, groupSettings);
            }
            groupSettings.put(value, this.get(setting));
        }
        LinkedHashMap retVal = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            retVal.put(entry.getKey(), new Settings(Collections.unmodifiableMap((Map)entry.getValue())));
        }
        return Collections.unmodifiableMap(retVal);
    }

    public Version getAsVersion(String setting, Version defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return Version.fromId(Integer.parseInt(sValue));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        for (String key : this.settings.keySet()) {
            int i = key.indexOf(".");
            if (i < 0) {
                names.add(key);
                continue;
            }
            names.add(key.substring(0, i));
        }
        return names;
    }

    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.settings.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        int result = this.settings != null ? this.settings.hashCode() : 0;
        return result;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        Builder builder = new Builder();
        int numberOfSettings = in.readVInt();
        for (int i = 0; i < numberOfSettings; ++i) {
            builder.put(in.readString(), in.readString());
        }
        return builder.build();
    }

    public static void writeSettingsToStream(Settings settings, StreamOutput out) throws IOException {
        out.writeVInt(settings.getAsMap().size());
        for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder settingsBuilder() {
        return new Builder();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Settings settings = SettingsFilter.filterSettings(params, this);
        if (!params.paramAsBoolean("flat_settings", false)) {
            for (Map.Entry<String, Object> entry : settings.getAsStructuredMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue(), XContentBuilder.FieldCaseConversion.NONE);
            }
        }
        return builder;
    }

    private static StartsWithPredicate startsWith(String prefix) {
        return new StartsWithPredicate(prefix);
    }

    private static final class StartsWithPredicate
    implements Predicate<String> {
        private String prefix;

        public StartsWithPredicate(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean apply(String input) {
            return input.startsWith(this.prefix);
        }
    }

    public static class Builder {
        public static final Settings EMPTY_SETTINGS = new Builder().build();
        private final Map<String, String> map = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public Map<String, String> internalMap() {
            return this.map;
        }

        public String remove(String key) {
            return this.map.remove(key);
        }

        public String get(String key) {
            String retVal = this.map.get(key);
            if (retVal != null) {
                return retVal;
            }
            String camelKey = Strings.toCamelCase(key);
            retVal = this.map.get(camelKey);
            if (retVal != null) {
                DEPRECATION_LOGGER.deprecated("Using deprecated setting name [" + camelKey + "], use [" + key + "] instead", new Object[0]);
            }
            return retVal;
        }

        public Builder put(Object ... settings) {
            if (settings.length == 1) {
                if (settings[0] instanceof Map) {
                    return this.put((Map)settings[0]);
                }
                if (settings[0] instanceof Settings) {
                    return this.put((Settings)settings[0]);
                }
            }
            if (settings.length % 2 != 0) {
                throw new IllegalArgumentException("array settings of key + value order doesn't hold correct number of arguments (" + settings.length + ")");
            }
            for (int i = 0; i < settings.length; ++i) {
                this.put(settings[i++].toString(), settings[i].toString());
            }
            return this;
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder put(String key, Class clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, Version version) {
            this.put(setting, version.id);
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value) + "ms");
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value) + "b");
            return this;
        }

        public Builder putArray(String setting, String ... values) {
            String value;
            this.remove(setting);
            int counter = 0;
            while ((value = this.map.remove(setting + '.' + counter++)) != null) {
            }
            for (int i = 0; i < values.length; ++i) {
                this.put(setting + "." + i, values[i]);
            }
            return this;
        }

        public Builder extendArray(String setting, String ... values) {
            String oldSingle = this.remove(setting);
            int counter = 0;
            while (this.map.containsKey(setting + '.' + counter)) {
                ++counter;
            }
            if (oldSingle != null) {
                this.put(setting + '.' + counter++, oldSingle);
            }
            for (String value : values) {
                this.put(setting + '.' + counter++, value);
            }
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings.getAsMap());
            this.map.putAll(settings.getAsMap());
            return this;
        }

        public Builder put(Map<String, String> settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings);
            this.map.putAll(settings);
            return this;
        }

        private void removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(Map<String, String> settings) {
            ArrayList<String> prefixesToRemove = new ArrayList<String>();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                Matcher matcher = ARRAY_PATTERN.matcher(entry.getKey());
                if (matcher.matches()) {
                    prefixesToRemove.add(matcher.group(1));
                    continue;
                }
                if (!Iterables.any(this.map.keySet(), Settings.startsWith(entry.getKey() + "."))) continue;
                prefixesToRemove.add(entry.getKey());
            }
            for (String prefix : prefixesToRemove) {
                Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(prefix + ".") && !entry.getKey().equals(prefix)) continue;
                    iterator.remove();
                }
            }
        }

        public Builder put(Properties properties) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public Builder loadFromDelimitedString(String value, char delimiter) {
            String[] values;
            for (String s2 : values = Strings.splitStringToArray(value, delimiter)) {
                int index = s2.indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException("value [" + s2 + "] for settings loaded with delimiter [" + delimiter + "] is malformed, missing =");
                }
                this.map.put(s2.substring(0, index), s2.substring(index + 1));
            }
            return this;
        }

        public Builder loadFromSource(String source) {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromSource(source);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromPath(Path path) throws SettingsException {
            try {
                return this.loadFromStream(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new SettingsException("Failed to open stream for url [" + path + "]", e);
            }
        }

        public Builder loadFromStream(String resourceName, InputStream is) throws SettingsException {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromResource(resourceName);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(Streams.copyToString(new InputStreamReader(is, Charsets.UTF_8)));
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + resourceName + "]", e);
            }
            return this;
        }

        public Builder putProperties(String prefix, Properties properties) {
            for (Object key1 : properties.keySet()) {
                String key = (String)key1;
                String value = properties.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                this.map.put(key.substring(prefix.length()), value);
            }
            return this;
        }

        public Builder putProperties(String prefix, Properties properties, String[] ignorePrefixes) {
            for (Object key1 : properties.keySet()) {
                String key = (String)key1;
                String value = properties.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                boolean ignore = false;
                for (String ignorePrefix : ignorePrefixes) {
                    if (!key.startsWith(ignorePrefix)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                this.map.put(key.substring(prefix.length()), value);
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    if (placeholderName.startsWith("env.")) {
                        return System.getenv(placeholderName.substring("env.".length()));
                    }
                    String value = System.getProperty(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    value = System.getenv(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return (String)Builder.this.map.get(placeholderName);
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("env.") || placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            for (Map.Entry<String, String> entry : Maps.newHashMap(this.map).entrySet()) {
                String value = propertyPlaceholder.replacePlaceholders(entry.getValue(), placeholderResolver);
                if (Strings.hasLength(value)) {
                    this.map.put(entry.getKey(), value);
                    continue;
                }
                this.map.remove(entry.getKey());
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<String, String> replacements = Maps.newHashMap();
            Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().startsWith(prefix)) continue;
                replacements.put(prefix + entry.getKey(), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        public Settings build() {
            return new Settings(Collections.unmodifiableMap(this.map));
        }
    }
}

