/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.util.SuppressForbidden;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class Loggers {
    private static final String commonPrefix = System.getProperty("es.logger.prefix", "org.elasticsearch.");
    public static final String SPACE = " ";
    private static boolean consoleLoggingEnabled = true;

    public static void disableConsoleLogging() {
        consoleLoggingEnabled = false;
    }

    public static void enableConsoleLogging() {
        consoleLoggingEnabled = true;
    }

    public static boolean consoleLoggingEnabled() {
        return consoleLoggingEnabled;
    }

    public static ESLogger getLogger(Class clazz, Settings settings, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, settings, shardId.index(), CollectionUtils.asArrayList(Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static ESLogger getLogger(String loggerName, Settings settings, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(loggerName, settings, CollectionUtils.asArrayList(shardId.index().name(), Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static ESLogger getLogger(Class clazz, Settings settings, Index index, String ... prefixes) {
        return Loggers.getLogger(clazz, settings, CollectionUtils.asArrayList(SPACE, index.name(), prefixes).toArray(new String[0]));
    }

    public static ESLogger getLogger(Class clazz, Settings settings, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), settings, prefixes);
    }

    @SuppressForbidden(reason="using localhost for logging on which host it is is fine")
    private static InetAddress getHostAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @SuppressForbidden(reason="do not know what this method does")
    public static ESLogger getLogger(String loggerName, Settings settings, String ... prefixes) {
        String name;
        InetAddress addr;
        ArrayList<String> prefixesList = new ArrayList<String>();
        if (settings.getAsBoolean("logger.logHostAddress", (Boolean)false).booleanValue() && (addr = Loggers.getHostAddress()) != null) {
            prefixesList.add(addr.getHostAddress());
        }
        if (settings.getAsBoolean("logger.logHostName", (Boolean)false).booleanValue() && (addr = Loggers.getHostAddress()) != null) {
            prefixesList.add(addr.getHostName());
        }
        if ((name = settings.get("name")) != null) {
            prefixesList.add(name);
        }
        if (prefixes != null && prefixes.length > 0) {
            prefixesList.addAll(Arrays.asList(prefixes));
        }
        return Loggers.getLogger(Loggers.getLoggerName(loggerName), prefixesList.toArray(new String[prefixesList.size()]));
    }

    public static ESLogger getLogger(ESLogger parentLogger, String s2) {
        return ESLoggerFactory.getLogger(parentLogger.getPrefix(), Loggers.getLoggerName(parentLogger.getName() + s2));
    }

    public static ESLogger getLogger(String s2) {
        return ESLoggerFactory.getLogger(Loggers.getLoggerName(s2));
    }

    public static ESLogger getLogger(Class clazz) {
        return ESLoggerFactory.getLogger(Loggers.getLoggerName(Loggers.buildClassLoggerName(clazz)));
    }

    public static ESLogger getLogger(Class clazz, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), prefixes);
    }

    public static ESLogger getLogger(String name, String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                sb.append(SPACE);
                prefix = sb.toString();
            }
        }
        return ESLoggerFactory.getLogger(prefix, Loggers.getLoggerName(name));
    }

    private static String buildClassLoggerName(Class clazz) {
        String name = clazz.getName();
        if (name.startsWith("org.elasticsearch.")) {
            name = Classes.getPackageName(clazz);
        }
        return name;
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("org.elasticsearch.")) {
            name = name.substring("org.elasticsearch.".length());
        }
        return commonPrefix + name;
    }
}

