/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import org.elasticsearch.common.io.CharSequenceReader;

public class FastStringReader
extends CharSequenceReader {
    private String str;
    private int length;
    private int next = 0;
    private int mark = 0;

    public FastStringReader(String s2) {
        this.str = s2;
        this.length = s2.length();
    }

    private void ensureOpen() throws IOException {
        if (this.length == -1) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.str.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.str.subSequence(start, end);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next + n, cbuf, off);
        this.next += n;
        return n;
    }

    @Override
    public long skip(long ns) throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.ensureOpen();
        this.mark = this.next;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.next = this.mark;
    }

    @Override
    public void close() {
        this.length = -1;
    }

    @Override
    public String toString() {
        return this.str;
    }
}

