/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.elasticsearch.common.inject.AbstractProcessor;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.spi.ScopeBinding;

class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        Scope existing;
        Scope scope = command.getScope();
        Class<? extends Annotation> annotationType = command.getAnnotationType();
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.withSource(annotationType).missingScopeAnnotation();
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.withSource(annotationType).missingRuntimeRetention(command.getSource());
        }
        if ((existing = this.injector.state.getScope(Preconditions.checkNotNull(annotationType, "annotation type"))) != null) {
            this.errors.duplicateScopes(existing, annotationType, scope);
        } else {
            this.injector.state.putAnnotation(annotationType, Preconditions.checkNotNull(scope, "scope"));
        }
        return true;
    }
}

