/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public abstract class CheckFileCommand
extends CliTool.Command {
    public CheckFileCommand(Terminal terminal) {
        super(terminal);
    }

    public abstract CliTool.ExitStatus doExecute(Settings var1, Environment var2) throws Exception;

    protected abstract Path[] pathsForPermissionsCheck(Settings var1, Environment var2) throws Exception;

    @Override
    public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
        Path[] paths = this.pathsForPermissionsCheck(settings, env);
        if (paths == null || paths.length == 0) {
            return this.doExecute(settings, env);
        }
        HashMap<Path, Set<PosixFilePermission>> permissions = Maps.newHashMapWithExpectedSize(paths.length);
        HashMap<Path, String> owners = Maps.newHashMapWithExpectedSize(paths.length);
        HashMap<Path, String> groups = Maps.newHashMapWithExpectedSize(paths.length);
        if (paths != null && paths.length > 0) {
            for (Path path : paths) {
                try {
                    boolean supportsPosixPermissions = Environment.getFileStore(path).supportsFileAttributeView(PosixFileAttributeView.class);
                    if (!supportsPosixPermissions) continue;
                    PosixFileAttributes attributes = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
                    permissions.put(path, attributes.permissions());
                    owners.put(path, attributes.owner().getName());
                    groups.put(path, attributes.group().getName());
                }
                catch (IOException supportsPosixPermissions) {
                    // empty catch block
                }
            }
        }
        CliTool.ExitStatus status = this.doExecute(settings, env);
        for (Map.Entry entry : permissions.entrySet()) {
            Set<PosixFilePermission> permissionsAfterWrite;
            Set permissionsBeforeWrite;
            if (!Files.exists((Path)entry.getKey(), new LinkOption[0]) || (permissionsBeforeWrite = (Set)entry.getValue()).equals(permissionsAfterWrite = Files.getPosixFilePermissions((Path)entry.getKey(), new LinkOption[0]))) continue;
            this.terminal.printWarn("The file permissions of [%s] have changed from [%s] to [%s]", entry.getKey(), PosixFilePermissions.toString(permissionsBeforeWrite), PosixFilePermissions.toString(permissionsAfterWrite));
            this.terminal.printWarn("Please ensure that the user account running Elasticsearch has read access to this file!", new Object[0]);
        }
        for (Map.Entry entry : owners.entrySet()) {
            if (!Files.exists((Path)entry.getKey(), new LinkOption[0])) continue;
            String ownerBeforeWrite = (String)entry.getValue();
            String ownerAfterWrite = Files.getOwner((Path)entry.getKey(), new LinkOption[0]).getName();
            if (ownerAfterWrite.equals(ownerBeforeWrite)) continue;
            this.terminal.printWarn("WARN: Owner of file [%s] used to be [%s], but now is [%s]", entry.getKey(), ownerBeforeWrite, ownerAfterWrite);
        }
        for (Map.Entry entry : groups.entrySet()) {
            if (!Files.exists((Path)entry.getKey(), new LinkOption[0])) continue;
            String groupBeforeWrite = (String)entry.getValue();
            String groupAfterWrite = Files.readAttributes((Path)entry.getKey(), PosixFileAttributes.class, new LinkOption[0]).group().getName();
            if (groupAfterWrite.equals(groupBeforeWrite)) continue;
            this.terminal.printWarn("WARN: Group of file [%s] used to be [%s], but now is [%s]", entry.getKey(), groupBeforeWrite, groupAfterWrite);
        }
        return status;
    }
}

