/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.settings.IndexDynamicSettings;

public class MetaDataUpdateSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private static final String ALL_NODES_VALUE = "all";
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final DynamicSettings dynamicSettings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService, AllocationService allocationService, @IndexDynamicSettings DynamicSettings dynamicSettings, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings);
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService.add(this);
        this.allocationService = allocationService;
        this.dynamicSettings = dynamicSettings;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().localNodeMaster()) {
            return;
        }
        int dataNodeCount = event.state().nodes().dataNodes().size();
        HashMap nrReplicasChanged = new HashMap();
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            String autoExpandReplicas = indexMetaData.getSettings().get("index.auto_expand_replicas");
            if (autoExpandReplicas == null || !Booleans.parseBoolean(autoExpandReplicas, true)) continue;
            try {
                int max;
                int min2;
                int dash = autoExpandReplicas.indexOf(45);
                if (-1 == dash) {
                    this.logger.warn("failed to set [{}] for index [{}], it should be dash delimited [{}]", "index.auto_expand_replicas", indexMetaData.getIndex(), autoExpandReplicas);
                    continue;
                }
                String sMin = autoExpandReplicas.substring(0, dash);
                try {
                    min2 = Integer.parseInt(sMin);
                }
                catch (NumberFormatException e) {
                    this.logger.warn("failed to set [{}] for index [{}], minimum value is not a number [{}]", e, "index.auto_expand_replicas", indexMetaData.getIndex(), sMin);
                    continue;
                }
                String sMax = autoExpandReplicas.substring(dash + 1);
                if (sMax.equals(ALL_NODES_VALUE)) {
                    max = dataNodeCount - 1;
                } else {
                    try {
                        max = Integer.parseInt(sMax);
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn("failed to set [{}] for index [{}], maximum value is neither [{}] nor a number [{}]", e, "index.auto_expand_replicas", indexMetaData.getIndex(), ALL_NODES_VALUE, sMax);
                        continue;
                    }
                }
                int numberOfReplicas = dataNodeCount - 1;
                if (numberOfReplicas < min2) {
                    numberOfReplicas = min2;
                } else if (numberOfReplicas > max) {
                    numberOfReplicas = max;
                }
                if (numberOfReplicas == indexMetaData.getNumberOfReplicas() || numberOfReplicas < min2 || numberOfReplicas > max) continue;
                if (!nrReplicasChanged.containsKey(numberOfReplicas)) {
                    nrReplicasChanged.put(numberOfReplicas, new ArrayList());
                }
                ((List)nrReplicasChanged.get(numberOfReplicas)).add(indexMetaData.getIndex());
            }
            catch (Exception e) {
                this.logger.warn("[{}] failed to parse auto expand replicas", e, indexMetaData.getIndex());
            }
        }
        if (nrReplicasChanged.size() > 0) {
            for (final Integer fNumberOfReplicas : nrReplicasChanged.keySet()) {
                Settings settings = Settings.settingsBuilder().put("index.number_of_replicas", fNumberOfReplicas).build();
                final List indices = (List)nrReplicasChanged.get(fNumberOfReplicas);
                UpdateSettingsClusterStateUpdateRequest updateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(indices.toArray(new String[indices.size()]))).settings(settings).ackTimeout(TimeValue.timeValueMillis(0L))).masterNodeTimeout(TimeValue.timeValueMinutes(10L));
                this.updateSettings(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                    @Override
                    public void onResponse(ClusterStateUpdateResponse response) {
                        for (String index : indices) {
                            MetaDataUpdateSettingsService.this.logger.info("[{}] auto expanded replicas to [{}]", index, fNumberOfReplicas);
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        for (String index : indices) {
                            MetaDataUpdateSettingsService.this.logger.warn("[{}] fail to auto expand replicas to [{}]", index, fNumberOfReplicas);
                        }
                    }
                });
            }
        }
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.settingsBuilder();
        updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        for (String key : updatedSettingsBuilder.internalMap().keySet()) {
            if (!key.equals("index.number_of_shards")) continue;
            listener.onFailure(new IllegalArgumentException("can't change the number of shards for an index"));
            return;
        }
        final Settings closeSettings = updatedSettingsBuilder.build();
        final HashSet<String> removedSettings = Sets.newHashSet();
        HashSet<String> errors = Sets.newHashSet();
        for (Map.Entry<String, String> setting : updatedSettingsBuilder.internalMap().entrySet()) {
            if (!this.dynamicSettings.hasDynamicSetting(setting.getKey())) {
                removedSettings.add(setting.getKey());
                continue;
            }
            String error = this.dynamicSettings.validateDynamicSetting(setting.getKey(), setting.getValue(), this.clusterService.state());
            if (error == null) continue;
            errors.add("[" + setting.getKey() + "] - " + error);
        }
        if (!errors.isEmpty()) {
            listener.onFailure(new IllegalArgumentException("can't process the settings: " + ((Object)errors).toString()));
            return;
        }
        if (!removedSettings.isEmpty()) {
            for (String removedSetting : removedSettings) {
                updatedSettingsBuilder.remove(removedSetting);
            }
        }
        final Settings openSettings = updatedSettingsBuilder.build();
        this.clusterService.submitStateUpdateTask("update-settings", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Boolean updateReadBlock;
                Boolean updateWriteBlock;
                Boolean updateMetaDataBlock;
                String[] actualIndices = MetaDataUpdateSettingsService.this.indexNameExpressionResolver.concreteIndices(currentState, IndicesOptions.strictExpand(), request.indices());
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                HashSet<String> openIndices = Sets.newHashSet();
                HashSet<String> closeIndices = Sets.newHashSet();
                for (String index : actualIndices) {
                    if (currentState.metaData().index(index).getState() == IndexMetaData.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (closeIndices.size() > 0 && closeSettings.get("index.number_of_replicas") != null) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update [%s] on closed indices [%s] - can leave index in an unopenable state", "index.number_of_replicas", closeIndices));
                }
                if (!removedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings[%s] for open indices [%s]", removedSettings, openIndices));
                }
                int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", (Integer)-1);
                if (updatedNumberOfReplicas != -1) {
                    routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    MetaDataUpdateSettingsService.this.logger.info("updating number_of_replicas to [{}] for indices {}", updatedNumberOfReplicas, actualIndices);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                Boolean updatedReadOnly = openSettings.getAsBoolean("index.blocks.read_only", null);
                if (updatedReadOnly != null) {
                    for (String index : actualIndices) {
                        if (updatedReadOnly.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                    }
                }
                if ((updateMetaDataBlock = openSettings.getAsBoolean("index.blocks.metadata", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateMetaDataBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                    }
                }
                if ((updateWriteBlock = openSettings.getAsBoolean("index.blocks.write", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateWriteBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                    }
                }
                if ((updateReadBlock = openSettings.getAsBoolean("index.blocks.read", null)) != null) {
                    for (String index : actualIndices) {
                        if (updateReadBlock.booleanValue()) {
                            blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                            continue;
                        }
                        blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                    }
                }
                if (!openIndices.isEmpty()) {
                    String[] indices = openIndices.toArray(new String[openIndices.size()]);
                    metaDataBuilder.updateSettings(openSettings, indices);
                }
                if (!closeIndices.isEmpty()) {
                    String[] indices = closeIndices.toArray(new String[closeIndices.size()]);
                    metaDataBuilder.updateSettings(closeSettings, indices);
                }
                ClusterState updatedState = ClusterState.builder(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder).blocks(blocks).build();
                RoutingAllocation.Result routingResult = MetaDataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                updatedState = ClusterState.builder(updatedState).routingResult(routingResult).build();
                return updatedState;
            }
        });
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetaData indexMetaData = metaDataBuilder.get(index);
                    if (indexMetaData == null || Version.CURRENT.equals(indexMetaData.getCreationVersion())) continue;
                    metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(Settings.settingsBuilder().put(indexMetaData.getSettings()).put("index.version.minimum_compatible", entry.getValue().v2()).put("index.version.upgraded", entry.getValue().v1())));
                }
                return ClusterState.builder(currentState).metaData(metaDataBuilder).build();
            }
        });
    }
}

