/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStatsAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public class InternalClusterInfoService
extends AbstractComponent
implements ClusterInfoService,
LocalNodeMasterListener,
ClusterStateListener {
    public static final String INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL = "cluster.info.update.interval";
    public static final String INTERNAL_CLUSTER_INFO_TIMEOUT = "cluster.info.update.timeout";
    private volatile TimeValue updateFrequency;
    private volatile Map<String, DiskUsage> leastAvailableSpaceUsages;
    private volatile Map<String, DiskUsage> mostAvailableSpaceUsages;
    private volatile Map<ShardRouting, String> shardRoutingToDataPath;
    private volatile Map<String, Long> shardSizes;
    private volatile boolean isMaster = false;
    private volatile boolean enabled;
    private volatile TimeValue fetchTimeout;
    private final TransportNodesStatsAction transportNodesStatsAction;
    private final TransportIndicesStatsAction transportIndicesStatsAction;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final List<ClusterInfoService.Listener> listeners = new CopyOnWriteArrayList<ClusterInfoService.Listener>();

    @Inject
    public InternalClusterInfoService(Settings settings, NodeSettingsService nodeSettingsService, TransportNodesStatsAction transportNodesStatsAction, TransportIndicesStatsAction transportIndicesStatsAction, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.leastAvailableSpaceUsages = Collections.emptyMap();
        this.mostAvailableSpaceUsages = Collections.emptyMap();
        this.shardRoutingToDataPath = Collections.emptyMap();
        this.shardSizes = Collections.emptyMap();
        this.transportNodesStatsAction = transportNodesStatsAction;
        this.transportIndicesStatsAction = transportIndicesStatsAction;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.updateFrequency = settings.getAsTime(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, TimeValue.timeValueSeconds(30L));
        this.fetchTimeout = settings.getAsTime(INTERNAL_CLUSTER_INFO_TIMEOUT, TimeValue.timeValueSeconds(15L));
        this.enabled = settings.getAsBoolean("cluster.routing.allocation.disk.threshold_enabled", (Boolean)true);
        nodeSettingsService.addListener(new ApplySettings());
        this.clusterService.add(this);
        this.clusterService.add(this);
    }

    @Override
    public void onMaster() {
        block4: {
            this.isMaster = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("I have been elected master, scheduling a ClusterInfoUpdateJob", new Object[0]);
            }
            try {
                this.threadPool.schedule(this.updateFrequency, this.executorName(), new SubmitReschedulingClusterInfoUpdatedJob());
                if (this.clusterService.state().getNodes().getDataNodes().size() > 1) {
                    this.threadPool.executor(this.executorName()).execute(new Runnable(){

                        @Override
                        public void run() {
                            InternalClusterInfoService.this.maybeRefresh();
                        }
                    });
                }
            }
            catch (EsRejectedExecutionException ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("Couldn't schedule cluster info update task - node might be shutting down", ex, new Object[0]);
            }
        }
    }

    @Override
    public void offMaster() {
        this.isMaster = false;
    }

    @Override
    public String executorName() {
        return "management";
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.enabled) {
            return;
        }
        boolean dataNodeAdded = false;
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.dataNode()) continue;
            dataNodeAdded = true;
            break;
        }
        if (this.isMaster && dataNodeAdded && this.clusterService.state().getNodes().getDataNodes().size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("data node was added, retrieving new cluster info", new Object[0]);
            }
            this.threadPool.executor(this.executorName()).execute(new Runnable(){

                @Override
                public void run() {
                    InternalClusterInfoService.this.maybeRefresh();
                }
            });
        }
        if (this.isMaster && event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                if (!removedNode.dataNode()) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Removing node from cluster info: {}", removedNode.getId());
                }
                if (this.leastAvailableSpaceUsages.containsKey(removedNode.getId())) {
                    HashMap<String, DiskUsage> newMaxUsages = new HashMap<String, DiskUsage>(this.leastAvailableSpaceUsages);
                    newMaxUsages.remove(removedNode.getId());
                    this.leastAvailableSpaceUsages = Collections.unmodifiableMap(newMaxUsages);
                }
                if (!this.mostAvailableSpaceUsages.containsKey(removedNode.getId())) continue;
                HashMap<String, DiskUsage> newMinUsages = new HashMap<String, DiskUsage>(this.mostAvailableSpaceUsages);
                newMinUsages.remove(removedNode.getId());
                this.mostAvailableSpaceUsages = Collections.unmodifiableMap(newMinUsages);
            }
        }
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, this.shardSizes, this.shardRoutingToDataPath);
    }

    @Override
    public void addListener(ClusterInfoService.Listener listener) {
        this.listeners.add(listener);
    }

    protected CountDownLatch updateNodeStats(ActionListener<NodesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
        nodesStatsRequest.clear();
        nodesStatsRequest.fs(true);
        nodesStatsRequest.timeout(this.fetchTimeout);
        this.transportNodesStatsAction.execute(nodesStatsRequest, new LatchedActionListener<NodesStatsResponse>(listener, latch));
        return latch;
    }

    protected CountDownLatch updateIndicesStats(ActionListener<IndicesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.clear();
        indicesStatsRequest.store(true);
        this.transportIndicesStatsAction.execute(indicesStatsRequest, new LatchedActionListener<IndicesStatsResponse>(listener, latch));
        return latch;
    }

    private final void maybeRefresh() {
        if (this.enabled) {
            this.refresh();
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("Skipping ClusterInfoUpdatedJob since it is disabled", new Object[0]);
        }
    }

    public final ClusterInfo refresh() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Performing ClusterInfoUpdateJob", new Object[0]);
        }
        CountDownLatch nodeLatch = this.updateNodeStats(new ActionListener<NodesStatsResponse>(){

            @Override
            public void onResponse(NodesStatsResponse nodeStatses) {
                HashMap<String, DiskUsage> newLeastAvaiableUsages = new HashMap<String, DiskUsage>();
                HashMap<String, DiskUsage> newMostAvaiableUsages = new HashMap<String, DiskUsage>();
                InternalClusterInfoService.fillDiskUsagePerNode(InternalClusterInfoService.this.logger, (NodeStats[])nodeStatses.getNodes(), newLeastAvaiableUsages, newMostAvaiableUsages);
                InternalClusterInfoService.this.leastAvailableSpaceUsages = Collections.unmodifiableMap(newLeastAvaiableUsages);
                InternalClusterInfoService.this.mostAvailableSpaceUsages = Collections.unmodifiableMap(newMostAvaiableUsages);
            }

            @Override
            public void onFailure(Throwable e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    InternalClusterInfoService.this.logger.error("NodeStatsAction timed out for ClusterInfoUpdateJob (reason [{}])", e.getMessage());
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                    }
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = Collections.emptyMap();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = Collections.emptyMap();
                }
            }
        });
        CountDownLatch indicesLatch = this.updateIndicesStats(new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                ShardStats[] stats = indicesStatsResponse.getShards();
                HashMap<String, Long> newShardSizes = new HashMap<String, Long>();
                HashMap<ShardRouting, String> newShardRoutingToDataPath = new HashMap<ShardRouting, String>();
                InternalClusterInfoService.buildShardLevelInfo(InternalClusterInfoService.this.logger, stats, newShardSizes, newShardRoutingToDataPath, InternalClusterInfoService.this.clusterService.state());
                InternalClusterInfoService.this.shardSizes = Collections.unmodifiableMap(newShardSizes);
                InternalClusterInfoService.this.shardRoutingToDataPath = Collections.unmodifiableMap(newShardRoutingToDataPath);
            }

            @Override
            public void onFailure(Throwable e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    InternalClusterInfoService.this.logger.error("IndicesStatsAction timed out for ClusterInfoUpdateJob (reason [{}])", e.getMessage());
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                    }
                    InternalClusterInfoService.this.shardSizes = Collections.emptyMap();
                    InternalClusterInfoService.this.shardRoutingToDataPath = Collections.emptyMap();
                }
            }
        });
        try {
            nodeLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Failed to update node information for ClusterInfoUpdateJob within {} timeout", this.fetchTimeout);
        }
        try {
            indicesLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Failed to update shard information for ClusterInfoUpdateJob within {} timeout", this.fetchTimeout);
        }
        ClusterInfo clusterInfo = this.getClusterInfo();
        for (ClusterInfoService.Listener l : this.listeners) {
            try {
                l.onNewInfo(clusterInfo);
            }
            catch (Exception e) {
                this.logger.info("Failed executing ClusterInfoService listener", e, new Object[0]);
            }
        }
        return clusterInfo;
    }

    static void buildShardLevelInfo(ESLogger logger, ShardStats[] stats, HashMap<String, Long> newShardSizes, HashMap<ShardRouting, String> newShardRoutingToDataPath, ClusterState state) {
        MetaData meta = state.getMetaData();
        for (ShardStats s2 : stats) {
            IndexMetaData indexMeta = meta.index(s2.getShardRouting().index());
            Settings indexSettings = indexMeta == null ? null : indexMeta.getSettings();
            newShardRoutingToDataPath.put(s2.getShardRouting(), s2.getDataPath());
            long size = s2.getStats().getStore().sizeInBytes();
            String sid = ClusterInfo.shardIdentifierFromRouting(s2.getShardRouting());
            if (logger.isTraceEnabled()) {
                logger.trace("shard: {} size: {}", sid, size);
            }
            if (indexSettings != null && IndexMetaData.isIndexUsingShadowReplicas(indexSettings)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("shard: {} is using shadow replicas and will be treated as size 0", sid);
                }
                size = 0L;
            }
            newShardSizes.put(sid, size);
        }
    }

    static void fillDiskUsagePerNode(ESLogger logger, NodeStats[] nodeStatsArray, Map<String, DiskUsage> newLeastAvaiableUsages, Map<String, DiskUsage> newMostAvaiableUsages) {
        for (NodeStats nodeStats : nodeStatsArray) {
            if (nodeStats.getFs() == null) {
                logger.warn("Unable to retrieve node FS stats for {}", nodeStats.getNode().name());
                continue;
            }
            FsInfo.Path leastAvailablePath = null;
            FsInfo.Path mostAvailablePath = null;
            for (FsInfo.Path info : nodeStats.getFs()) {
                if (leastAvailablePath == null) {
                    assert (mostAvailablePath == null);
                    mostAvailablePath = leastAvailablePath = info;
                    continue;
                }
                if (leastAvailablePath.getAvailable().bytes() > info.getAvailable().bytes()) {
                    leastAvailablePath = info;
                    continue;
                }
                if (mostAvailablePath.getAvailable().bytes() >= info.getAvailable().bytes()) continue;
                mostAvailablePath = info;
            }
            String nodeId = nodeStats.getNode().id();
            String nodeName = nodeStats.getNode().getName();
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}], most available: total disk: {}, available disk: {} / least available: total disk: {}, available disk: {}", nodeId, mostAvailablePath.getTotal(), leastAvailablePath.getAvailable(), leastAvailablePath.getTotal(), leastAvailablePath.getAvailable());
            }
            if (leastAvailablePath.getTotal().bytes() < 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}], skipping", nodeId, leastAvailablePath.getTotal().bytes());
                }
            } else {
                newLeastAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().bytes(), leastAvailablePath.getAvailable().bytes()));
            }
            if (mostAvailablePath.getTotal().bytes() < 0L) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}], skipping", nodeId, mostAvailablePath.getTotal().bytes());
                continue;
            }
            newMostAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().bytes(), mostAvailablePath.getAvailable().bytes()));
        }
    }

    public class SubmitReschedulingClusterInfoUpdatedJob
    implements Runnable {
        @Override
        public void run() {
            block3: {
                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                    InternalClusterInfoService.this.logger.trace("Submitting new rescheduling cluster info update job", new Object[0]);
                }
                try {
                    InternalClusterInfoService.this.threadPool.executor(InternalClusterInfoService.this.executorName()).execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                InternalClusterInfoService.this.maybeRefresh();
                            }
                            catch (Throwable throwable) {
                                if (InternalClusterInfoService.this.isMaster) {
                                    if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                                        InternalClusterInfoService.this.logger.trace("Scheduling next run for updating cluster info in: {}", InternalClusterInfoService.this.updateFrequency.toString());
                                    }
                                    try {
                                        InternalClusterInfoService.this.threadPool.schedule(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.this.executorName(), this);
                                    }
                                    catch (EsRejectedExecutionException ex) {
                                        InternalClusterInfoService.this.logger.debug("Reschedule cluster info service was rejected", ex, new Object[0]);
                                    }
                                }
                                throw throwable;
                            }
                            if (InternalClusterInfoService.this.isMaster) {
                                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                                    InternalClusterInfoService.this.logger.trace("Scheduling next run for updating cluster info in: {}", InternalClusterInfoService.this.updateFrequency.toString());
                                }
                                try {
                                    InternalClusterInfoService.this.threadPool.schedule(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.this.executorName(), this);
                                }
                                catch (EsRejectedExecutionException ex) {
                                    InternalClusterInfoService.this.logger.debug("Reschedule cluster info service was rejected", ex, new Object[0]);
                                }
                            }
                        }
                    });
                }
                catch (EsRejectedExecutionException ex) {
                    if (!InternalClusterInfoService.this.logger.isDebugEnabled()) break block3;
                    InternalClusterInfoService.this.logger.debug("Couldn't re-schedule cluster info update task - node might be shutting down", ex, new Object[0]);
                }
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue newFetchTimeout;
            TimeValue newUpdateFrequency = settings.getAsTime(InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, null);
            Boolean newEnabled = settings.getAsBoolean("cluster.routing.allocation.disk.threshold_enabled", null);
            if (newUpdateFrequency != null) {
                if (newUpdateFrequency.getMillis() < TimeValue.timeValueSeconds(10L).getMillis()) {
                    InternalClusterInfoService.this.logger.warn("[{}] set too low [{}] (< 10s)", InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, newUpdateFrequency);
                    throw new IllegalStateException("Unable to set cluster.info.update.interval less than 10 seconds");
                }
                InternalClusterInfoService.this.logger.info("updating [{}] from [{}] to [{}]", InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, InternalClusterInfoService.this.updateFrequency, newUpdateFrequency);
                InternalClusterInfoService.this.updateFrequency = newUpdateFrequency;
            }
            if ((newFetchTimeout = settings.getAsTime(InternalClusterInfoService.INTERNAL_CLUSTER_INFO_TIMEOUT, null)) != null) {
                InternalClusterInfoService.this.logger.info("updating fetch timeout [{}] from [{}] to [{}]", InternalClusterInfoService.INTERNAL_CLUSTER_INFO_TIMEOUT, InternalClusterInfoService.this.fetchTimeout, newFetchTimeout);
                InternalClusterInfoService.this.fetchTimeout = newFetchTimeout;
            }
            if (newEnabled != null) {
                InternalClusterInfoService.this.enabled = newEnabled;
            }
        }
    }
}

