/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.PrintStream;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.spi.Message;

final class StartupError
extends RuntimeException {
    static final int STACKTRACE_LIMIT = 30;
    static final String GUICE_PACKAGE = "org.elasticsearch.common.inject";

    StartupError(Throwable cause) {
        super(cause);
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        Throwable originalCause = this.getCause();
        Throwable cause = originalCause;
        if (cause instanceof CreationException) {
            cause = StartupError.getFirstGuiceCause((CreationException)cause);
        }
        String message = cause.toString();
        s2.println(message);
        if (cause != null) {
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause != originalCause && !message.equals(cause.toString())) {
                s2.println("Likely root cause: " + cause);
            }
            StackTraceElement[] stack = cause.getStackTrace();
            int linesWritten = 0;
            for (int i = 0; i < stack.length; ++i) {
                if (linesWritten == 30) {
                    s2.println("\t<<<truncated>>>");
                    break;
                }
                String line = stack[i].toString();
                if (line.startsWith(GUICE_PACKAGE)) {
                    while (i + 1 < stack.length && stack[i + 1].toString().startsWith(GUICE_PACKAGE)) {
                        ++i;
                    }
                    s2.println("\tat <<<guice>>>");
                    ++linesWritten;
                    continue;
                }
                s2.println("\tat " + line.toString());
                ++linesWritten;
            }
        }
        if (!(originalCause instanceof CreationException)) {
            s2.println("Refer to the log for complete error details.");
        }
    }

    static Throwable getFirstGuiceCause(CreationException guice) {
        for (Message message : guice.getErrorMessages()) {
            Throwable cause = message.getCause();
            if (cause == null) continue;
            return cause;
        }
        return guice;
    }
}

