/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.Strings;

class JavaVersion
implements Comparable<JavaVersion> {
    private final List<Integer> version;
    private static final JavaVersion CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));

    public List<Integer> getVersion() {
        return Collections.unmodifiableList(this.version);
    }

    private JavaVersion(List<Integer> version) {
        this.version = version;
    }

    public static JavaVersion parse(String value) {
        String[] components;
        if (value == null) {
            throw new NullPointerException("value");
        }
        if ("".equals(value)) {
            throw new IllegalArgumentException("value");
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version.add(Integer.valueOf(component));
        }
        return new JavaVersion(version);
    }

    public static boolean isValid(String value) {
        return value.matches("^0*[0-9]+(\\.[0-9]+)*$");
    }

    public static JavaVersion current() {
        return CURRENT;
    }

    @Override
    public int compareTo(JavaVersion o) {
        int len = Math.max(this.version.size(), o.version.size());
        for (int i = 0; i < len; ++i) {
            int s2;
            int d = i < this.version.size() ? this.version.get(i) : 0;
            int n = s2 = i < o.version.size() ? o.version.get(i) : 0;
            if (s2 < d) {
                return 1;
            }
            if (s2 <= d) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        return Strings.collectionToDelimitedString(this.version, ".");
    }
}

