/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Objects;
import org.elasticsearch.ThreadPermission;

public class SecureSM
extends SecurityManager {
    private final boolean allowTestExit;
    private static final boolean DEBUG = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                String v = System.getProperty("java.security.debug");
                return v != null && v.length() > 0;
            }
            catch (SecurityException e) {
                return false;
            }
        }
    });
    private static final Permission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final Permission MODIFY_ARBITRARY_THREAD_PERMISSION = new ThreadPermission("modifyArbitraryThread");
    private static final Permission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    private static final Permission MODIFY_ARBITRARY_THREADGROUP_PERMISSION = new ThreadPermission("modifyArbitraryThreadGroup");
    static final String[] TEST_RUNNER_PACKAGES = new String[]{"org.apache.maven.surefire.booter.", "com.carrotsearch.ant.tasks.junit4.", "org.eclipse.jdt.internal.junit.runner.", "com.intellij.rt.execution.junit."};

    public SecureSM() {
        this(false);
    }

    public SecureSM(boolean allowTestExit) {
        this.allowTestExit = allowTestExit;
    }

    @Override
    public void checkAccess(Thread t) {
        try {
            this.checkThreadAccess(t);
        }
        catch (SecurityException e) {
            if (DEBUG) {
                System.out.println("access: caller thread=" + Thread.currentThread());
                System.out.println("access: target thread=" + t);
                this.debugThreadGroups(Thread.currentThread().getThreadGroup(), t.getThreadGroup());
            }
            throw e;
        }
    }

    @Override
    public void checkAccess(ThreadGroup g2) {
        try {
            this.checkThreadGroupAccess(g2);
        }
        catch (SecurityException e) {
            if (DEBUG) {
                System.out.println("access: caller thread=" + Thread.currentThread());
                this.debugThreadGroups(Thread.currentThread().getThreadGroup(), g2);
            }
            throw e;
        }
    }

    private void debugThreadGroups(ThreadGroup caller, ThreadGroup target) {
        System.out.println("access: caller group=" + caller);
        System.out.println("access: target group=" + target);
    }

    protected void checkThreadAccess(Thread t) {
        Objects.requireNonNull(t);
        this.checkPermission(MODIFY_THREAD_PERMISSION);
        ThreadGroup source = Thread.currentThread().getThreadGroup();
        ThreadGroup target = t.getThreadGroup();
        if (target == null) {
            return;
        }
        if (!source.parentOf(target)) {
            this.checkPermission(MODIFY_ARBITRARY_THREAD_PERMISSION);
        }
    }

    protected void checkThreadGroupAccess(ThreadGroup g2) {
        Objects.requireNonNull(g2);
        this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        ThreadGroup source = Thread.currentThread().getThreadGroup();
        ThreadGroup target = g2;
        if (source == null) {
            return;
        }
        if (!source.parentOf(target)) {
            this.checkPermission(MODIFY_ARBITRARY_THREADGROUP_PERMISSION);
        }
    }

    @Override
    public void checkExit(int status) {
        if (!this.allowTestExit) {
            throw new SecurityException("exit(" + status + ") not allowed by system policy");
        }
        this.checkTestExit(status);
    }

    protected void checkTestExit(final int status) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String systemClassName = System.class.getName();
                String runtimeClassName = Runtime.class.getName();
                String exitMethodHit = null;
                for (StackTraceElement se : Thread.currentThread().getStackTrace()) {
                    String className = se.getClassName();
                    String methodName = se.getMethodName();
                    if (("exit".equals(methodName) || "halt".equals(methodName)) && (systemClassName.equals(className) || runtimeClassName.equals(className))) {
                        exitMethodHit = className + '#' + methodName + '(' + status + ')';
                        continue;
                    }
                    if (exitMethodHit == null) continue;
                    for (String testPackage : TEST_RUNNER_PACKAGES) {
                        if (!className.startsWith(testPackage)) continue;
                        return null;
                    }
                    break;
                }
                if (exitMethodHit == null) {
                    exitMethodHit = "JVM exit method";
                }
                throw new SecurityException(exitMethodHit + " calls are not allowed because they terminate the test runner's JVM.");
            }
        });
        super.checkExit(status);
    }
}

