/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.response;

import java.util.List;
import org.apache.storm.elasticsearch.doc.IndexItemDoc;

public class BulkIndexResponse {
    private boolean errors;
    private long took;
    private List<IndexItemDoc> items;

    public boolean hasErrors() {
        return this.errors;
    }

    public void setErrors(boolean errors) {
        this.errors = errors;
    }

    public long getTook() {
        return this.took;
    }

    public void setTook(long took) {
        this.took = took;
    }

    public List<IndexItemDoc> getItems() {
        return this.items;
    }

    public void setItems(List<IndexItemDoc> items) {
        this.items = items;
    }

    public Integer getFirstError() {
        if (this.items == null || this.items.isEmpty()) {
            return null;
        }
        for (IndexItemDoc item : this.items) {
            int status = item.getIndex().getStatus();
            if (400 > status || status > 599) continue;
            return status;
        }
        return null;
    }

    public String getFirstResult() {
        if (this.items == null || this.items.isEmpty()) {
            return null;
        }
        return this.items.get(0).getIndex().getResult();
    }
}

