/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class EsConfig
implements Serializable {
    private final HttpHost[] httpHosts;
    private Integer maxRetryTimeoutMillis;
    private Header[] defaultHeaders;
    private RestClient.FailureListener failureListener;
    private RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback;
    private RestClientBuilder.RequestConfigCallback requestConfigCallback;
    private String pathPrefix;

    public EsConfig() {
        this("http://localhost:9200");
    }

    public EsConfig(String ... urls) {
        if (urls.length == 0) {
            throw new IllegalArgumentException("urls is required");
        }
        this.httpHosts = new HttpHost[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URI uri = EsConfig.toUri(urls[i]);
            this.httpHosts[i] = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
    }

    static URI toUri(String url) throws IllegalArgumentException {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url " + url);
        }
    }

    public EsConfig withMaxRetryTimeoutMillis(Integer maxRetryTimeoutMillis) {
        this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
        return this;
    }

    public EsConfig withDefaultHeaders(Header[] defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public EsConfig withFailureListener(RestClient.FailureListener failureListener) {
        this.failureListener = failureListener;
        return this;
    }

    public EsConfig withHttpClientConfigCallback(RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public EsConfig withRequestConfigCallback(RestClientBuilder.RequestConfigCallback requestConfigCallback) {
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public EsConfig withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    public HttpHost[] getHttpHosts() {
        return this.httpHosts;
    }

    public Integer getMaxRetryTimeoutMillis() {
        return this.maxRetryTimeoutMillis;
    }

    public Header[] getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public RestClient.FailureListener getFailureListener() {
        return this.failureListener;
    }

    public RestClientBuilder.HttpClientConfigCallback getHttpClientConfigCallback() {
        return this.httpClientConfigCallback;
    }

    public RestClientBuilder.RequestConfigCallback getRequestConfigCallback() {
        return this.requestConfigCallback;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }
}

