/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.storm.elasticsearch.bolt.AbstractEsBolt;
import org.apache.storm.elasticsearch.common.DefaultEsTupleMapper;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.elasticsearch.response.PercolateResponse;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.elasticsearch.client.Response;

public class EsPercolateBolt
extends AbstractEsBolt {
    private final EsTupleMapper tupleMapper;

    public EsPercolateBolt(EsConfig esConfig) {
        this(esConfig, new DefaultEsTupleMapper());
    }

    public EsPercolateBolt(EsConfig esConfig, EsTupleMapper tupleMapper) {
        super(esConfig);
        this.tupleMapper = Objects.requireNonNull(tupleMapper);
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        super.prepare(map, topologyContext, outputCollector);
    }

    public void process(Tuple tuple) {
        try {
            String source = this.tupleMapper.getSource((ITuple)tuple);
            String index = this.tupleMapper.getIndex((ITuple)tuple);
            String type = this.tupleMapper.getType((ITuple)tuple);
            HashMap<String, Object> indexParams = new HashMap<String, Object>();
            indexParams.put(type, null);
            String percolateDoc = "{\"doc\": " + source + "}";
            Response response = client.performRequest("get", EsPercolateBolt.getEndpoint(index, type, "_percolate"), new HashMap<String, String>(), (HttpEntity)new StringEntity(percolateDoc), new Header[0]);
            PercolateResponse percolateResponse = objectMapper.readValue(response.getEntity().getContent(), PercolateResponse.class);
            if (!percolateResponse.getMatches().isEmpty()) {
                for (PercolateResponse.Match match : percolateResponse.getMatches()) {
                    this.collector.emit((List)new Values(new Object[]{source, match}));
                }
            }
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        outputFieldsDeclarer.declare(new Fields(new String[]{"source", "match"}));
    }
}

